% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlatypusDB_find_CDR3s.R
\name{PlatypusDB_find_CDR3s}
\alias{PlatypusDB_find_CDR3s}
\title{CDR3 query function for PlatypusDB}
\usage{
PlatypusDB_find_CDR3s(VDJ.cdr3s.aa, VJ.cdr3s.aa, projects.to.search)
}
\arguments{
\item{VDJ.cdr3s.aa}{Character A VDJ CDR3s amino acid sequence to search for}

\item{VJ.cdr3s.aa}{Character A VJ CDR3s amino acid sequence to search for}

\item{projects.to.search}{Optional character vector. Defaults to "ALL". Names of projects to search within.}
}
\value{
A list of subsets of VDJ matrices from projects
containing the query VDJ CDR3 (out[[1]]),
the VJ CDR3 (out[[2]]) and cells containing both the query VDJ and VJ CDR3s (out[[3]])
}
\description{
Queries for the occurrence of CDR3 sequences in public datasets on PlatypusDB.
}
\examples{
\dontrun{

public_clones <- PlatypusDB_find_CDR3s(VDJ.cdr3s.aa = "CMRYGNYWYFDVW"
, VJ.cdr3s.aa = "CLQHGESPFTF", projects.to.search = "ALL")

}
}
