% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlatypusDB_list_projects.R
\name{PlatypusDB_list_projects}
\alias{PlatypusDB_list_projects}
\title{Lists metadata tables of available projects on PlatypusDB}
\usage{
PlatypusDB_list_projects(keyword)
}
\arguments{
\item{keyword}{Character. Keyword by which to search project ids (First Author, Year) in the database. Defaults to an empty string ("") which will list all projects currently available}
}
\value{
A list of metadata tables by project. List element names correspond to project ids to use in the PlatypusDB_fetch function
}
\description{
Lists metadata tables of available projects on PlatypusDB
}
\examples{
\dontrun{

#Get list of all available projects and metadata.
PlatypusDB_projects <- PlatypusDB_list_projects()

#Names of list are project ids to use in PlatypusDB_fetch function
names(PlatypusDB_projects)
#Common format: first author, date, letter a-z (all lowercase)

#View metadata of a specific project
print(PlatypusDB_projects[["Kuhn2021a"]])

}

}
