% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_dublets.R
\name{VDJ_dublets}
\alias{VDJ_dublets}
\title{Only Platypus v2 Produces a matrix indicating either the number of cells or clones which contain multiple heavy or light chains (or alpha/beta in the case of T cells).}
\usage{
VDJ_dublets(clonotype.list, clone.level)
}
\arguments{
\item{clonotype.list}{Output from VDJ_analyze function. This should be a list of clonotype dataframes, with each list element corresponding to a single VDJ repertoire.}

\item{clone.level}{Logical indicating whether the matrix should display information on the clone level. TRUE will result in matrices containing information about the number of chains on the clonal level. FALSE will result in matrices depicting the numnber of cells.}
}
\value{
Returns a list of matrices containing the number of heavy/light chains per either cell or clone depending on the clone.level parameter. This can then be supplied to heatmap functions directly. Each list element corresponds to each of the input list elements of clonotypes.
}
\description{
Only Platypus v2 Produces a matrix indicating either the number of cells or clones which contain multiple heavy or light chains (or alpha/beta in the case of T cells).
}
\examples{
\dontrun{
example.vdj.analyze <- VDJ_dublets(clonotype.list = "VDJ.analyze.output", clone.level=T)
}

}
