% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platform_design.R
\name{platform_design}
\alias{platform_design}
\title{Design of an optimal two-period multi-arm platform trial with delayed arms}
\usage{
platform_design(
  nt,
  K,
  M,
  fwer,
  marginal.power,
  min.marginal.power = marginal.power,
  delta,
  seed = 123
)
}
\arguments{
\item{nt}{the number of patients already enrolled on each of the K experimental arms in
the first period at the time the new arms are added}

\item{K}{the number of experimental arms in the  first period in a two-period K+M trial}

\item{M}{the number of delayed (newly added) experimental arms added in the second period}

\item{fwer}{the family-wise error rate (FWER) to be controlled, default to be the same throughout
the trial}

\item{marginal.power}{the marginal power to achieve in the first period in a two-period K+M trial}

\item{min.marginal.power}{the user-defined lower limit of the marginal power in the K+M
trial (with K+M experimental arms and 1 common control arm), default to be the marginal
power in the first period}

\item{delta}{the standardized clinical effect size expected to be detected in the trial}

\item{seed}{an integer for random number generation for numerically evaluating integration, default = 123}
}
\value{
The function returns a list, including \bold{designs}, \bold{flag.dp}, \bold{flag.mp}, and \bold{flag.dpmp}.

\bold{designs} contains the recommended optimal design parameters for periods 1 and 2
including:

\verb{    }\emph{n1} and \emph{n0_1}, the sample sizes of each of the K experimental arms and the
concurrent control, respectively, in the first period

\verb{    }\emph{n2} and \emph{n0_2}, the updated sample sizes of each of the K + M experimental
arms and its corresponding concurrent control, respectively, after adding M experimental arms in the second period

\verb{    }\emph{nt} and \emph{n0t}, the number of patients already enrolled on each of the K
experimental arms and the control arm, respectively, in the first period at the time the M new
arms are added

\verb{    }\emph{nc}, the updated total sample size of the control arm
after adding M experimental arms in the second period, i.e., the sum of concurrent (n0_2)
and nonconcurrent (n0t) controls

\verb{    }\emph{N2}, the total sample size of the two-period K+M experimental arm (and 1 control
arm) platform trial

\verb{    }\emph{A1},  the allocation ratio (control to experimental arm) before the M new
experimental arms are added and after the initial K experimental arms end

\verb{    }\emph{A2},  the allocation ratio after the M new experimental arms are added and before
the initial K experimental arms end

\verb{    }\emph{cor1}, the correlation of Z-test statistics between any two of the K initially opened
experimental arms (or between any two of the M newly added arms)

\verb{    }\emph{cor2}, the correlation of Z-test statistics between any pair of one initially
opened and one newly added experimental arm

\verb{    }\emph{critical_value1}, the critical value for the comparison between any of the K
experimental arms in the first period and the corresponding control

\verb{    }\emph{critical_value2}, the critical value for the comparison between any of the K + M
experimental arms in the second period and the corresponding control

\verb{    }\emph{marginal.power1} and \emph{marginal.power2}, the marginal power for the first
and second period, respectively

\verb{    }\emph{disjunctive.power1} and \emph{disjunctive.power2}, the disjunctive power for the
first and second period, respectively

\verb{    }\emph{standardized_effect_size}, the standardized clinical effect size
expected to be detected in the trial

\bold{flag.dp}, \bold{flag.mp}, and \bold{flag.dpmp} indicate if the lower limit of
disjunctive power, marginal power, and both of them has(have) met, respectively.
}
\description{
Find optimal design(s), provide the design parameters for a two-period K+M experimental
arm platform trial
}
\details{
Providing an optimized design in terms of minimizing the total sample size for adding M additional
experimental arms in the middle of a clinical trial which originally (in the first period) have K
experimental arms and 1 control arm, given user-defined FWER and marginal power.
}
\examples{
\donttest{platform_design(nt = 30, K = 2, M = 2, fwer = 0.025, marginal.power = 0.8, delta = 0.4)}

#flag.dpmp == 0, lower limits of marginal and disjunctive power are both met
#$designs
#      n1  n0_1  n2 n0_2 nt n0t  nc  N2
#15669 101  143 107  198 30  43 241 669
#15994 101  143 106  202 30  43 245 669
#16315 101  143 105  206 30  43 249 669
#16632 101  143 104  210 30  43 253 669

#        A1       A2       cor1      cor2         critical_value1 critical_value2
#15669 1.414214 2.012987 0.3508197 0.2746316        2.220604        2.475233
#15994 1.414214 2.092105 0.3441558 0.2708949        2.220604        2.475790
#16315 1.414214 2.173333 0.3376206 0.2671464        2.220604        2.476330
#16632 1.414214 2.256757 0.3312102 0.2633910        2.220604        2.476854

#          marginal.power1 marginal.power2 disjunctive.power1 disjunctive.power2
#15669             0.8       0.8001100          0.9222971          0.9853799
#15994             0.8       0.8003363          0.9222971          0.9857541
#16315             0.8       0.8003878          0.9222971          0.9860900
#16632             0.8       0.8002699          0.9222971          0.9863903

 #          standardized_effect_size
#15669          0.4
#15994          0.4
#16315          0.4
#16632          0.4

#$flag.dp
#[1] 0

#$flag.mp
#[1] 0

#$flag.dpmp
#[1] 0

}
\references{
\verb{    }Pan, H., Yuan, X. and Ye, J. (2022). An optimal two-period multi-arm confirmatory platform design
with adding new arms. Manuscript submitted for publication.

\verb{    }Dunnett, C. W. (1955). A multiple comparison procedure for comparing
several treatments with a control. Journal of the American Statistical
Association, 50(272), 1096-1121.
}
\author{
\verb{    }Xiaomeng Yuan, Haitao Pan
}
