% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_aux.R
\name{main}
\alias{main}
\title{Main: Run everything}
\usage{
main(blast.file, srst2.file, coverage.filter = NA, sureness.filter = NA,
  length.filter = NA, combine.inc = NA, plotly.user, plotly.api,
  post.plotly = NA, anonymize = NA, main.title = "Plasmid Profiles")
}
\arguments{
\item{blast.file}{Either system location of blast results (tsv) or dataframe}

\item{srst2.file}{Either system location of srst2 results (tsv) or dataframe}

\item{coverage.filter}{Filters results below percent read coverage specified (eg. 80)}

\item{sureness.filter}{Filters results below sureness specified (eg. 0.75)}

\item{length.filter}{Filters plasmid sequences shorter than length specified (eg. 10000)}

\item{combine.inc}{Flag to combine incompatibility sub-groups into their main type (set to 1)}

\item{plotly.user}{Enter your plotly info to upload to (\href{https://plot.ly/feed/}{Plotly})}

\item{plotly.api}{Enter your plotly info to upload to (\href{https://plot.ly/feed/}{Plotly})}

\item{post.plotly}{Flag to post to (\href{https://plot.ly/feed/}{Plotly})}

\item{anonymize}{Flag to post to anonymize plasmids and samples (set to 1)}

\item{main.title}{A title for the figure}
}
\value{
Saves output files in working directory
}
\description{
Run all the interim functions to produce outputs.
Can be run in order individually if desired.
\enumerate{
  \item \code{\link{read_blast}} Import the blast file, add column names
  \item \code{\link{blast_parser}} Parse imported file
  \item \code{\link{amr_positives}} Detect AMR positive plasmids
  \item \code{\link{read_srst2}} Import SRST2 file
  \item \code{\link{combine_results}} Combine SRST2 and Blast
  \item \code{\link{zetner_score}} Add Sureness value
  \item \code{\link{amr_presence}} Add detected AMR to report
  \item \code{\link{subsampler}} Apply filters to report
  \item \code{\link{order_report}} Arrange report
  \item \code{\link{save_files}} Save JPG and CSV
  \item \code{\link{create_plotly}} Creates plot
  \item \code{\link{save_files}} Save HTML plot
}
}
\examples{
main(blastdata,
srst2data,
coverage.filter=NA,
sureness.filter=0.75,
length.filter=10000,
main.title="Example Results")
}

