% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Triangle.R
\name{Triangle}
\alias{Triangle}
\title{R6 class representing a triangle}
\description{
A triangle has three vertices. They are named A, B, C.
}
\note{
The Steiner ellipse is also the smallest area ellipse which passes
  through the vertices of the triangle, and thus can be obtained with
  the function \code{\link{EllipseFromThreeBoundaryPoints}}. We can also
  note that the major axis of the Steiner ellipse is the Deming
  least squares line of the three triangle vertices.
}
\examples{
# incircle and excircles
A <- c(0,0); B <- c(1,2); C <- c(3.5,1)
t <- Triangle$new(A, B, C)
incircle <- t$incircle()
excircles <- t$excircles()
JA <- excircles$A$center
JB <- excircles$B$center
JC <- excircles$C$center
JAJBJC <- Triangle$new(JA, JB, JC)
A_JA <- Line$new(A, JA, FALSE, FALSE)
B_JB <- Line$new(B, JB, FALSE, FALSE)
C_JC <- Line$new(C, JC, FALSE, FALSE)
opar <- par(mar = c(0,0,0,0))
plot(NULL, asp = 1, xlim = c(0,6), ylim = c(-4,4),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(incircle, border = "orange")
draw(excircles$A); draw(excircles$B); draw(excircles$C)
draw(JAJBJC, col = "blue")
draw(A_JA, col = "green")
draw(B_JB, col = "green")
draw(C_JC, col = "green")
par(opar)


## ------------------------------------------------
## Method `Triangle$new`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(1,0), c(1,1))
t
t$C
t$C <- c(2,2)
t

## ------------------------------------------------
## Method `Triangle$print`
## ------------------------------------------------

Triangle$new(c(0,0), c(1,0), c(1,1))

## ------------------------------------------------
## Method `Triangle$NagelTriangle`
## ------------------------------------------------

t <- Triangle$new(c(0,-2), c(0.5,1), c(3,0.6))
lineAB <- Line$new(t$A, t$B)
lineAC <- Line$new(t$A, t$C)
lineBC <- Line$new(t$B, t$C)
NagelTriangle <- t$NagelTriangle(NagelPoint = TRUE)
NagelPoint <- attr(NagelTriangle, "Nagel point")
excircles <- t$excircles()
opar <- par(mar = c(0,0,0,0))
plot(0, 0, type="n", asp = 1, xlim = c(-1,5), ylim = c(-3,3),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(lineAB); draw(lineAC); draw(lineBC)
draw(excircles$A, border = "orange")
draw(excircles$B, border = "orange")
draw(excircles$C, border = "orange")
draw(NagelTriangle, lwd = 2, col = "red")
draw(Line$new(t$A, NagelTriangle$A, FALSE, FALSE), col = "blue")
draw(Line$new(t$B, NagelTriangle$B, FALSE, FALSE), col = "blue")
draw(Line$new(t$C, NagelTriangle$C, FALSE, FALSE), col = "blue")
points(rbind(NagelPoint), pch = 19)
par(opar)

## ------------------------------------------------
## Method `Triangle$symmedialTriangle`
## ------------------------------------------------

t <- Triangle$new(c(0,-2), c(0.5,1), c(3,0.6))
symt <- t$symmedialTriangle()
symmedianA <- Line$new(t$A, symt$A, FALSE, FALSE)
symmedianB <- Line$new(t$B, symt$B, FALSE, FALSE)
symmedianC <- Line$new(t$C, symt$C, FALSE, FALSE)
K <- t$symmedianPoint()
opar <- par(mar = c(0,0,0,0))
plot(NULL, asp = 1, xlim = c(-1,5), ylim = c(-3,3),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(symmedianA, lwd = 2, col = "blue")
draw(symmedianB, lwd = 2, col = "blue")
draw(symmedianC, lwd = 2, col = "blue")
points(rbind(K), pch = 19, col = "red")
par(opar)

## ------------------------------------------------
## Method `Triangle$MalfattiCircles`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
Mcircles <- t$MalfattiCircles(TRUE)
plot(NULL, asp = 1, xlim = c(0,2.5), ylim = c(0,2.5),
     xlab = NA, ylab = NA)
grid()
draw(t, col = "blue", lwd = 2)
invisible(lapply(Mcircles, draw, col = "green", border = "red"))
invisible(lapply(attr(Mcircles, "tangencyPoints"), function(P){
  points(P[1], P[2], pch = 19)
}))

## ------------------------------------------------
## Method `Triangle$trilinearToPoint`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(2,1), c(5,7))
incircle <- t$incircle()
t$trilinearToPoint(1, 1, 1)
incircle$center

## ------------------------------------------------
## Method `Triangle$SteinerEllipse`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
ell <- t$SteinerEllipse()
plot(NULL, asp = 1, xlim = c(0,2.5), ylim = c(-0.7,2.4),
     xlab = NA, ylab = NA)
draw(t, col = "blue", lwd = 2)
draw(ell, border = "red", lwd =2)

## ------------------------------------------------
## Method `Triangle$SteinerInellipse`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
ell <- t$SteinerInellipse()
plot(NULL, asp = 1, xlim = c(0,2.5), ylim = c(-0.1,2.4),
     xlab = NA, ylab = NA)
draw(t, col = "blue", lwd = 2)
draw(ell, border = "red", lwd =2)
}
\seealso{
\code{\link{TriangleThreeLines}} to define a triangle by three lines.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{A}}{get or set the vertex \code{A}}

\item{\code{B}}{get or set the vertex \code{B}}

\item{\code{C}}{get or set the vertex \code{C}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Triangle-new}{\code{Triangle$new()}}
\item \href{#method-Triangle-print}{\code{Triangle$print()}}
\item \href{#method-Triangle-flatness}{\code{Triangle$flatness()}}
\item \href{#method-Triangle-a}{\code{Triangle$a()}}
\item \href{#method-Triangle-b}{\code{Triangle$b()}}
\item \href{#method-Triangle-c}{\code{Triangle$c()}}
\item \href{#method-Triangle-edges}{\code{Triangle$edges()}}
\item \href{#method-Triangle-perimeter}{\code{Triangle$perimeter()}}
\item \href{#method-Triangle-orientation}{\code{Triangle$orientation()}}
\item \href{#method-Triangle-contains}{\code{Triangle$contains()}}
\item \href{#method-Triangle-isAcute}{\code{Triangle$isAcute()}}
\item \href{#method-Triangle-angleA}{\code{Triangle$angleA()}}
\item \href{#method-Triangle-angleB}{\code{Triangle$angleB()}}
\item \href{#method-Triangle-angleC}{\code{Triangle$angleC()}}
\item \href{#method-Triangle-angles}{\code{Triangle$angles()}}
\item \href{#method-Triangle-X175}{\code{Triangle$X175()}}
\item \href{#method-Triangle-VeldkampIsoperimetricPoint}{\code{Triangle$VeldkampIsoperimetricPoint()}}
\item \href{#method-Triangle-centroid}{\code{Triangle$centroid()}}
\item \href{#method-Triangle-orthocenter}{\code{Triangle$orthocenter()}}
\item \href{#method-Triangle-area}{\code{Triangle$area()}}
\item \href{#method-Triangle-incircle}{\code{Triangle$incircle()}}
\item \href{#method-Triangle-inradius}{\code{Triangle$inradius()}}
\item \href{#method-Triangle-incenter}{\code{Triangle$incenter()}}
\item \href{#method-Triangle-excircles}{\code{Triangle$excircles()}}
\item \href{#method-Triangle-excentralTriangle}{\code{Triangle$excentralTriangle()}}
\item \href{#method-Triangle-BevanPoint}{\code{Triangle$BevanPoint()}}
\item \href{#method-Triangle-medialTriangle}{\code{Triangle$medialTriangle()}}
\item \href{#method-Triangle-orthicTriangle}{\code{Triangle$orthicTriangle()}}
\item \href{#method-Triangle-incentralTriangle}{\code{Triangle$incentralTriangle()}}
\item \href{#method-Triangle-NagelTriangle}{\code{Triangle$NagelTriangle()}}
\item \href{#method-Triangle-NagelPoint}{\code{Triangle$NagelPoint()}}
\item \href{#method-Triangle-GergonneTriangle}{\code{Triangle$GergonneTriangle()}}
\item \href{#method-Triangle-GergonnePoint}{\code{Triangle$GergonnePoint()}}
\item \href{#method-Triangle-tangentialTriangle}{\code{Triangle$tangentialTriangle()}}
\item \href{#method-Triangle-symmedialTriangle}{\code{Triangle$symmedialTriangle()}}
\item \href{#method-Triangle-symmedianPoint}{\code{Triangle$symmedianPoint()}}
\item \href{#method-Triangle-circumcircle}{\code{Triangle$circumcircle()}}
\item \href{#method-Triangle-circumcenter}{\code{Triangle$circumcenter()}}
\item \href{#method-Triangle-circumradius}{\code{Triangle$circumradius()}}
\item \href{#method-Triangle-BrocardCircle}{\code{Triangle$BrocardCircle()}}
\item \href{#method-Triangle-BrocardPoints}{\code{Triangle$BrocardPoints()}}
\item \href{#method-Triangle-LemoineCircleI}{\code{Triangle$LemoineCircleI()}}
\item \href{#method-Triangle-LemoineCircleII}{\code{Triangle$LemoineCircleII()}}
\item \href{#method-Triangle-LemoineTriangle}{\code{Triangle$LemoineTriangle()}}
\item \href{#method-Triangle-LemoineCircleIII}{\code{Triangle$LemoineCircleIII()}}
\item \href{#method-Triangle-ParryCircle}{\code{Triangle$ParryCircle()}}
\item \href{#method-Triangle-outerSoddyCircle}{\code{Triangle$outerSoddyCircle()}}
\item \href{#method-Triangle-pedalTriangle}{\code{Triangle$pedalTriangle()}}
\item \href{#method-Triangle-CevianTriangle}{\code{Triangle$CevianTriangle()}}
\item \href{#method-Triangle-MalfattiCircles}{\code{Triangle$MalfattiCircles()}}
\item \href{#method-Triangle-AjimaMalfatti1}{\code{Triangle$AjimaMalfatti1()}}
\item \href{#method-Triangle-AjimaMalfatti2}{\code{Triangle$AjimaMalfatti2()}}
\item \href{#method-Triangle-equalDetourPoint}{\code{Triangle$equalDetourPoint()}}
\item \href{#method-Triangle-trilinearToPoint}{\code{Triangle$trilinearToPoint()}}
\item \href{#method-Triangle-pointToTrilinear}{\code{Triangle$pointToTrilinear()}}
\item \href{#method-Triangle-isogonalConjugate}{\code{Triangle$isogonalConjugate()}}
\item \href{#method-Triangle-rotate}{\code{Triangle$rotate()}}
\item \href{#method-Triangle-translate}{\code{Triangle$translate()}}
\item \href{#method-Triangle-SteinerEllipse}{\code{Triangle$SteinerEllipse()}}
\item \href{#method-Triangle-SteinerInellipse}{\code{Triangle$SteinerInellipse()}}
\item \href{#method-Triangle-MandartInellipse}{\code{Triangle$MandartInellipse()}}
\item \href{#method-Triangle-randomPoints}{\code{Triangle$randomPoints()}}
\item \href{#method-Triangle-hexylTriangle}{\code{Triangle$hexylTriangle()}}
\item \href{#method-Triangle-clone}{\code{Triangle$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-new"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Triangle} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$new(A, B, C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{A, B, C}}{vertices}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Triangle} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(1,0), c(1,1))
t
t$C
t$C <- c(2,2)
t
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-print"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-print}{}}}
\subsection{Method \code{print()}}{
Show instance of a triangle object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Triangle$new(c(0,0), c(1,0), c(1,1))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-flatness"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-flatness}{}}}
\subsection{Method \code{flatness()}}{
Flatness of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$flatness()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A number between 0 and 1. A triangle is flat when its flatness is 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-a"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-a}{}}}
\subsection{Method \code{a()}}{
Length of the side \code{BC}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$a()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-b"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-b}{}}}
\subsection{Method \code{b()}}{
Length of the side \code{AC}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$b()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-c"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-c}{}}}
\subsection{Method \code{c()}}{
Length of the side \code{AB}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$c()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-edges"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-edges}{}}}
\subsection{Method \code{edges()}}{
The lengths of the sides of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$edges()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A named numeric vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-perimeter"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-perimeter}{}}}
\subsection{Method \code{perimeter()}}{
Perimeter of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$perimeter()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The perimeter of the triangle.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-orientation"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-orientation}{}}}
\subsection{Method \code{orientation()}}{
Determine the orientation of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$orientation()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An integer: 1 for counterclockwise, -1 for clockwise, 0 for collinear.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-contains"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-contains}{}}}
\subsection{Method \code{contains()}}{
Determine whether a point lies inside the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$contains(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-isAcute"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-isAcute}{}}}
\subsection{Method \code{isAcute()}}{
Determines whether the reference triangle is acute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$isAcute()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
`TRUE` if the triangle is acute (or right), `FALSE` otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-angleA"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-angleA}{}}}
\subsection{Method \code{angleA()}}{
Angle at the vertex A.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$angleA()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The angle at the vertex A in radians.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-angleB"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-angleB}{}}}
\subsection{Method \code{angleB()}}{
Angle at the vertex B.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$angleB()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The angle at the vertex B in radians.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-angleC"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-angleC}{}}}
\subsection{Method \code{angleC()}}{
Angle at the vertex C.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$angleC()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The angle at the vertex C in radians.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-angles"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-angles}{}}}
\subsection{Method \code{angles()}}{
The three angles of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$angles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A named vector containing the values of the angles in radians.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-X175"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-X175}{}}}
\subsection{Method \code{X175()}}{
Isoperimetric point, also known as the X(175) triangle
  center; this is the center of the outer Soddy circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$X175()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-VeldkampIsoperimetricPoint"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-VeldkampIsoperimetricPoint}{}}}
\subsection{Method \code{VeldkampIsoperimetricPoint()}}{
Isoperimetric point in the sense of Veldkamp.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$VeldkampIsoperimetricPoint()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The isoperimetric point in the sense of Veldkamp, if it exists.
Otherwise, returns `NULL`.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-centroid"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-centroid}{}}}
\subsection{Method \code{centroid()}}{
Centroid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$centroid()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-orthocenter"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-orthocenter}{}}}
\subsection{Method \code{orthocenter()}}{
Orthocenter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$orthocenter()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-area"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-area}{}}}
\subsection{Method \code{area()}}{
Area of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$area()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-incircle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-incircle}{}}}
\subsection{Method \code{incircle()}}{
Incircle of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$incircle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-inradius"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-inradius}{}}}
\subsection{Method \code{inradius()}}{
Inradius of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$inradius()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-incenter"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-incenter}{}}}
\subsection{Method \code{incenter()}}{
Incenter of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$incenter()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-excircles"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-excircles}{}}}
\subsection{Method \code{excircles()}}{
Excircles of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$excircles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with the three excircles, \code{Circle} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-excentralTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-excentralTriangle}{}}}
\subsection{Method \code{excentralTriangle()}}{
Excentral triangle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$excentralTriangle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-BevanPoint"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-BevanPoint}{}}}
\subsection{Method \code{BevanPoint()}}{
Bevan point. This is the circumcenter of the
excentral triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$BevanPoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-medialTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-medialTriangle}{}}}
\subsection{Method \code{medialTriangle()}}{
Medial triangle. Its vertices are the mid-points of the
sides of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$medialTriangle()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-orthicTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-orthicTriangle}{}}}
\subsection{Method \code{orthicTriangle()}}{
Orthic triangle. Its vertices are the feet of the altitudes
of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$orthicTriangle()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-incentralTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-incentralTriangle}{}}}
\subsection{Method \code{incentralTriangle()}}{
Incentral triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$incentralTriangle()}\if{html}{\out{</div>}}
}

\subsection{Details}{
It is the triangle whose vertices are the intersections of the
reference triangle's angle bisectors with the respective opposite sides.
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-NagelTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-NagelTriangle}{}}}
\subsection{Method \code{NagelTriangle()}}{
Nagel triangle (or extouch triangle) of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$NagelTriangle(NagelPoint = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{NagelPoint}}{logical, whether to return the Nagel point as attribute}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,-2), c(0.5,1), c(3,0.6))
lineAB <- Line$new(t$A, t$B)
lineAC <- Line$new(t$A, t$C)
lineBC <- Line$new(t$B, t$C)
NagelTriangle <- t$NagelTriangle(NagelPoint = TRUE)
NagelPoint <- attr(NagelTriangle, "Nagel point")
excircles <- t$excircles()
opar <- par(mar = c(0,0,0,0))
plot(0, 0, type="n", asp = 1, xlim = c(-1,5), ylim = c(-3,3),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(lineAB); draw(lineAC); draw(lineBC)
draw(excircles$A, border = "orange")
draw(excircles$B, border = "orange")
draw(excircles$C, border = "orange")
draw(NagelTriangle, lwd = 2, col = "red")
draw(Line$new(t$A, NagelTriangle$A, FALSE, FALSE), col = "blue")
draw(Line$new(t$B, NagelTriangle$B, FALSE, FALSE), col = "blue")
draw(Line$new(t$C, NagelTriangle$C, FALSE, FALSE), col = "blue")
points(rbind(NagelPoint), pch = 19)
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-NagelPoint"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-NagelPoint}{}}}
\subsection{Method \code{NagelPoint()}}{
Nagel point of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$NagelPoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-GergonneTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-GergonneTriangle}{}}}
\subsection{Method \code{GergonneTriangle()}}{
Gergonne triangle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$GergonneTriangle(GergonnePoint = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{GergonnePoint}}{logical, whether to return the Gergonne point as an attribute}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The Gergonne triangle is also known as the
\emph{intouch triangle} or the \emph{contact triangle}.
This is the triangle made of the three tangency points of the incircle.
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-GergonnePoint"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-GergonnePoint}{}}}
\subsection{Method \code{GergonnePoint()}}{
Gergonne point of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$GergonnePoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-tangentialTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-tangentialTriangle}{}}}
\subsection{Method \code{tangentialTriangle()}}{
Tangential triangle of the reference triangle.
This is the triangle formed by the lines tangent to the circumcircle of
the reference triangle at its vertices. It does not exist for a
right triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$tangentialTriangle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-symmedialTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-symmedialTriangle}{}}}
\subsection{Method \code{symmedialTriangle()}}{
Symmedial triangle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$symmedialTriangle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Triangle} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,-2), c(0.5,1), c(3,0.6))
symt <- t$symmedialTriangle()
symmedianA <- Line$new(t$A, symt$A, FALSE, FALSE)
symmedianB <- Line$new(t$B, symt$B, FALSE, FALSE)
symmedianC <- Line$new(t$C, symt$C, FALSE, FALSE)
K <- t$symmedianPoint()
opar <- par(mar = c(0,0,0,0))
plot(NULL, asp = 1, xlim = c(-1,5), ylim = c(-3,3),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(symmedianA, lwd = 2, col = "blue")
draw(symmedianB, lwd = 2, col = "blue")
draw(symmedianC, lwd = 2, col = "blue")
points(rbind(K), pch = 19, col = "red")
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-symmedianPoint"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-symmedianPoint}{}}}
\subsection{Method \code{symmedianPoint()}}{
Symmedian point of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$symmedianPoint()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A point.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-circumcircle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-circumcircle}{}}}
\subsection{Method \code{circumcircle()}}{
Circumcircle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$circumcircle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-circumcenter"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-circumcenter}{}}}
\subsection{Method \code{circumcenter()}}{
Circumcenter of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$circumcenter()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-circumradius"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-circumradius}{}}}
\subsection{Method \code{circumradius()}}{
Circumradius of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$circumradius()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-BrocardCircle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-BrocardCircle}{}}}
\subsection{Method \code{BrocardCircle()}}{
The Brocard circle of the reference triangle (also known
as the seven-point circle).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$BrocardCircle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-BrocardPoints"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-BrocardPoints}{}}}
\subsection{Method \code{BrocardPoints()}}{
Brocard points of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$BrocardPoints()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of two points, the first Brocard point and the second
Brocard point.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-LemoineCircleI"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-LemoineCircleI}{}}}
\subsection{Method \code{LemoineCircleI()}}{
The first Lemoine circle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$LemoineCircleI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-LemoineCircleII"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-LemoineCircleII}{}}}
\subsection{Method \code{LemoineCircleII()}}{
The second Lemoine circle of the reference triangle (also
known as the cosine circle)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$LemoineCircleII()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-LemoineTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-LemoineTriangle}{}}}
\subsection{Method \code{LemoineTriangle()}}{
The Lemoine triangle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$LemoineTriangle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-LemoineCircleIII"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-LemoineCircleIII}{}}}
\subsection{Method \code{LemoineCircleIII()}}{
The third Lemoine circle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$LemoineCircleIII()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-ParryCircle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-ParryCircle}{}}}
\subsection{Method \code{ParryCircle()}}{
Parry circle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$ParryCircle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-outerSoddyCircle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-outerSoddyCircle}{}}}
\subsection{Method \code{outerSoddyCircle()}}{
Soddy outer circle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$outerSoddyCircle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-pedalTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-pedalTriangle}{}}}
\subsection{Method \code{pedalTriangle()}}{
Pedal triangle of a point with respect to the reference
triangle. The pedal triangle of a point \code{P} is the triangle whose
vertices are the feet of the perpendiculars from \code{P} to the sides
of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$pedalTriangle(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{a point}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-CevianTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-CevianTriangle}{}}}
\subsection{Method \code{CevianTriangle()}}{
Cevian triangle of a point with respect to the reference
triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$CevianTriangle(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{a point}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-MalfattiCircles"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-MalfattiCircles}{}}}
\subsection{Method \code{MalfattiCircles()}}{
Malfatti circles of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$MalfattiCircles(tangencyPoints = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangencyPoints}}{logical, whether to retourn the tangency points of
the Malfatti circles as an attribute.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the three Malfatti circles, \code{Circle} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
Mcircles <- t$MalfattiCircles(TRUE)
plot(NULL, asp = 1, xlim = c(0,2.5), ylim = c(0,2.5),
     xlab = NA, ylab = NA)
grid()
draw(t, col = "blue", lwd = 2)
invisible(lapply(Mcircles, draw, col = "green", border = "red"))
invisible(lapply(attr(Mcircles, "tangencyPoints"), function(P){
  points(P[1], P[2], pch = 19)
}))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-AjimaMalfatti1"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-AjimaMalfatti1}{}}}
\subsection{Method \code{AjimaMalfatti1()}}{
First Ajima-Malfatti point of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$AjimaMalfatti1()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-AjimaMalfatti2"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-AjimaMalfatti2}{}}}
\subsection{Method \code{AjimaMalfatti2()}}{
Second Ajima-Malfatti point of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$AjimaMalfatti2()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-equalDetourPoint"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-equalDetourPoint}{}}}
\subsection{Method \code{equalDetourPoint()}}{
Equal detour point of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$equalDetourPoint(detour = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{detour}}{logical, whether to return the detour as an attribute}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Also known as the X(176) triangle center.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-trilinearToPoint"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-trilinearToPoint}{}}}
\subsection{Method \code{trilinearToPoint()}}{
Point given by trilinear coordinates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$trilinearToPoint(x, y, z)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x, y, z}}{trilinear coordinates}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The point with trilinear coordinates \code{x:y:z} with respect to
the reference triangle.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(2,1), c(5,7))
incircle <- t$incircle()
t$trilinearToPoint(1, 1, 1)
incircle$center
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-pointToTrilinear"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-pointToTrilinear}{}}}
\subsection{Method \code{pointToTrilinear()}}{
Give the trilinear coordinates of a point with respect to
the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$pointToTrilinear(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{a point}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The trilinear coordinates, a numeric vector of length 3.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-isogonalConjugate"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-isogonalConjugate}{}}}
\subsection{Method \code{isogonalConjugate()}}{
Isogonal conjugate of a point with respect to
the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$isogonalConjugate(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{a point}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A point, the isogonal conjugate of \code{P}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-rotate}{}}}
\subsection{Method \code{rotate()}}{
Rotate the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$rotate(alpha, O, degrees = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{angle of rotation}

\item{\code{O}}{center of rotation}

\item{\code{degrees}}{logical, whether \code{alpha} is given in degrees}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-translate"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-translate}{}}}
\subsection{Method \code{translate()}}{
Translate the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$translate(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{the vector of translation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-SteinerEllipse"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-SteinerEllipse}{}}}
\subsection{Method \code{SteinerEllipse()}}{
The Steiner ellipse (or circumellipse) of the reference
triangle. This is the ellipse passing through the three vertices of
the triangle and centered at the centroid of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$SteinerEllipse()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{Ellipse} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
ell <- t$SteinerEllipse()
plot(NULL, asp = 1, xlim = c(0,2.5), ylim = c(-0.7,2.4),
     xlab = NA, ylab = NA)
draw(t, col = "blue", lwd = 2)
draw(ell, border = "red", lwd =2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-SteinerInellipse"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-SteinerInellipse}{}}}
\subsection{Method \code{SteinerInellipse()}}{
The Steiner inellipse (or midpoint ellipse) of the reference
triangle. This is the ellipse tangent to the sides of the triangle at
their midpoints, and centered at the centroid of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$SteinerInellipse()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{Ellipse} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
ell <- t$SteinerInellipse()
plot(NULL, asp = 1, xlim = c(0,2.5), ylim = c(-0.1,2.4),
     xlab = NA, ylab = NA)
draw(t, col = "blue", lwd = 2)
draw(ell, border = "red", lwd =2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-MandartInellipse"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-MandartInellipse}{}}}
\subsection{Method \code{MandartInellipse()}}{
The Mandart inellipse of the reference triangle. This is
  the unique ellipse tangent to the triangle's sides at the contact
  points of its excircles
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$MandartInellipse()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{Ellipse} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-randomPoints"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-randomPoints}{}}}
\subsection{Method \code{randomPoints()}}{
Random points on or in the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$randomPoints(n, where = "in")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{an integer, the desired number of points}

\item{\code{where}}{\code{"in"} to generate inside the triangle,
\code{"on"} to generate on the triangle}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The generated points in a two columns matrix with \code{n} rows.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-hexylTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-hexylTriangle}{}}}
\subsection{Method \code{hexylTriangle()}}{
Hexyl triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$hexylTriangle()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Triangle-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Triangle-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
