% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Triangle.R
\name{Triangle}
\alias{Triangle}
\title{R6 class representing a triangle}
\description{
A triangle has three vertices. They are named A, B, C.
}
\note{
The Steiner ellipse is also the smallest area ellipse which passes
  through the vertices of the triangle, and thus can be obtained with
  the function \code{\link{EllipseFromThreeBoundaryPoints}}. We can also
  note that the major axis of the Steiner ellipse is the Deming
  least squares line of the three triangle vertices.
}
\examples{
# incircle and excircles
A <- c(0,0); B <- c(1,2); C <- c(3.5,1)
t <- Triangle$new(A, B, C)
incircle <- t$incircle()
excircles <- t$excircles()
JA <- excircles$A$center
JB <- excircles$B$center
JC <- excircles$C$center
JAJBJC <- Triangle$new(JA, JB, JC)
A_JA <- Line$new(A, JA, FALSE, FALSE)
B_JB <- Line$new(B, JB, FALSE, FALSE)
C_JC <- Line$new(C, JC, FALSE, FALSE)
opar <- par(mar = c(0,0,0,0))
plot(NULL, asp = 1, xlim = c(0,6), ylim = c(-4,4),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(incircle, border = "orange")
draw(excircles$A); draw(excircles$B); draw(excircles$C)
draw(JAJBJC, col = "blue")
draw(A_JA, col = "green")
draw(B_JB, col = "green")
draw(C_JC, col = "green")
par(opar)


## ------------------------------------------------
## Method `Triangle$new`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(1,0), c(1,1))
t
t$C
t$C <- c(2,2)
t

## ------------------------------------------------
## Method `Triangle$print`
## ------------------------------------------------

Triangle$new(c(0,0), c(1,0), c(1,1))

## ------------------------------------------------
## Method `Triangle$NagelTriangle`
## ------------------------------------------------

t <- Triangle$new(c(0,-2), c(0.5,1), c(3,0.6))
lineAB <- Line$new(t$A, t$B)
lineAC <- Line$new(t$A, t$C)
lineBC <- Line$new(t$B, t$C)
NagelTriangle <- t$NagelTriangle(NagelPoint = TRUE)
NagelPoint <- attr(NagelTriangle, "Nagel point")
excircles <- t$excircles()
opar <- par(mar = c(0,0,0,0))
plot(0, 0, type="n", asp = 1, xlim = c(-1,5), ylim = c(-3,3),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(lineAB); draw(lineAC); draw(lineBC)
draw(excircles$A, border = "orange")
draw(excircles$B, border = "orange")
draw(excircles$C, border = "orange")
draw(NagelTriangle, lwd = 2, col = "red")
draw(Line$new(t$A, NagelTriangle$A, FALSE, FALSE), col = "blue")
draw(Line$new(t$B, NagelTriangle$B, FALSE, FALSE), col = "blue")
draw(Line$new(t$C, NagelTriangle$C, FALSE, FALSE), col = "blue")
points(rbind(NagelPoint), pch = 19)
par(opar)

## ------------------------------------------------
## Method `Triangle$symmedialTriangle`
## ------------------------------------------------

t <- Triangle$new(c(0,-2), c(0.5,1), c(3,0.6))
symt <- t$symmedialTriangle()
symmedianA <- Line$new(t$A, symt$A, FALSE, FALSE)
symmedianB <- Line$new(t$B, symt$B, FALSE, FALSE)
symmedianC <- Line$new(t$C, symt$C, FALSE, FALSE)
K <- t$symmedianPoint()
opar <- par(mar = c(0,0,0,0))
plot(NULL, asp = 1, xlim = c(-1,5), ylim = c(-3,3),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(symmedianA, lwd = 2, col = "blue")
draw(symmedianB, lwd = 2, col = "blue")
draw(symmedianC, lwd = 2, col = "blue")
points(rbind(K), pch = 19, col = "red")
par(opar)

## ------------------------------------------------
## Method `Triangle$MalfattiCircles`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
Mcircles <- t$MalfattiCircles(TRUE)
plot(NULL, asp = 1, xlim = c(0,2.5), ylim = c(0,2.5),
     xlab = NA, ylab = NA)
grid()
draw(t, col = "blue", lwd = 2)
invisible(lapply(Mcircles, draw, col = "green", border = "red"))
invisible(lapply(attr(Mcircles, "tangencyPoints"), function(P){
  points(P[1], P[2], pch = 19)
}))

## ------------------------------------------------
## Method `Triangle$trilinearToPoint`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(2,1), c(5,7))
incircle <- t$incircle()
t$trilinearToPoint(1, 1, 1)
incircle$center

## ------------------------------------------------
## Method `Triangle$SteinerEllipse`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
ell <- t$SteinerEllipse()
plot(NULL, asp = 1, xlim = c(0,2.5), ylim = c(-0.7,2.4),
     xlab = NA, ylab = NA)
draw(t, col = "blue", lwd = 2)
draw(ell, border = "red", lwd =2)

## ------------------------------------------------
## Method `Triangle$SteinerInellipse`
## ------------------------------------------------

t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
ell <- t$SteinerInellipse()
plot(NULL, asp = 1, xlim = c(0,2.5), ylim = c(-0.1,2.4),
     xlab = NA, ylab = NA)
draw(t, col = "blue", lwd = 2)
draw(ell, border = "red", lwd =2)
}
\seealso{
\code{\link{TriangleThreeLines}} to define a triangle by three lines.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{A}}{get or set the vertex \code{A}}

\item{\code{B}}{get or set the vertex \code{B}}

\item{\code{C}}{get or set the vertex \code{C}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Triangle$new()}}
\item \href{#method-print}{\code{Triangle$print()}}
\item \href{#method-flatness}{\code{Triangle$flatness()}}
\item \href{#method-a}{\code{Triangle$a()}}
\item \href{#method-b}{\code{Triangle$b()}}
\item \href{#method-c}{\code{Triangle$c()}}
\item \href{#method-edges}{\code{Triangle$edges()}}
\item \href{#method-orientation}{\code{Triangle$orientation()}}
\item \href{#method-contains}{\code{Triangle$contains()}}
\item \href{#method-isAcute}{\code{Triangle$isAcute()}}
\item \href{#method-angleA}{\code{Triangle$angleA()}}
\item \href{#method-angleB}{\code{Triangle$angleB()}}
\item \href{#method-angleC}{\code{Triangle$angleC()}}
\item \href{#method-angles}{\code{Triangle$angles()}}
\item \href{#method-X175}{\code{Triangle$X175()}}
\item \href{#method-VeldkampIsoperimetricPoint}{\code{Triangle$VeldkampIsoperimetricPoint()}}
\item \href{#method-centroid}{\code{Triangle$centroid()}}
\item \href{#method-orthocenter}{\code{Triangle$orthocenter()}}
\item \href{#method-area}{\code{Triangle$area()}}
\item \href{#method-incircle}{\code{Triangle$incircle()}}
\item \href{#method-inradius}{\code{Triangle$inradius()}}
\item \href{#method-incenter}{\code{Triangle$incenter()}}
\item \href{#method-excircles}{\code{Triangle$excircles()}}
\item \href{#method-excentralTriangle}{\code{Triangle$excentralTriangle()}}
\item \href{#method-BevanPoint}{\code{Triangle$BevanPoint()}}
\item \href{#method-medialTriangle}{\code{Triangle$medialTriangle()}}
\item \href{#method-orthicTriangle}{\code{Triangle$orthicTriangle()}}
\item \href{#method-incentralTriangle}{\code{Triangle$incentralTriangle()}}
\item \href{#method-NagelTriangle}{\code{Triangle$NagelTriangle()}}
\item \href{#method-NagelPoint}{\code{Triangle$NagelPoint()}}
\item \href{#method-GergonneTriangle}{\code{Triangle$GergonneTriangle()}}
\item \href{#method-GergonnePoint}{\code{Triangle$GergonnePoint()}}
\item \href{#method-tangentialTriangle}{\code{Triangle$tangentialTriangle()}}
\item \href{#method-symmedialTriangle}{\code{Triangle$symmedialTriangle()}}
\item \href{#method-symmedianPoint}{\code{Triangle$symmedianPoint()}}
\item \href{#method-circumcircle}{\code{Triangle$circumcircle()}}
\item \href{#method-circumcenter}{\code{Triangle$circumcenter()}}
\item \href{#method-circumradius}{\code{Triangle$circumradius()}}
\item \href{#method-BrocardCircle}{\code{Triangle$BrocardCircle()}}
\item \href{#method-BrocardPoints}{\code{Triangle$BrocardPoints()}}
\item \href{#method-LemoineCircleI}{\code{Triangle$LemoineCircleI()}}
\item \href{#method-LemoineCircleII}{\code{Triangle$LemoineCircleII()}}
\item \href{#method-LemoineTriangle}{\code{Triangle$LemoineTriangle()}}
\item \href{#method-LemoineCircleIII}{\code{Triangle$LemoineCircleIII()}}
\item \href{#method-ParryCircle}{\code{Triangle$ParryCircle()}}
\item \href{#method-pedalTriangle}{\code{Triangle$pedalTriangle()}}
\item \href{#method-CevianTriangle}{\code{Triangle$CevianTriangle()}}
\item \href{#method-MalfattiCircles}{\code{Triangle$MalfattiCircles()}}
\item \href{#method-AjimaMalfatti1}{\code{Triangle$AjimaMalfatti1()}}
\item \href{#method-AjimaMalfatti2}{\code{Triangle$AjimaMalfatti2()}}
\item \href{#method-equalDetourPoint}{\code{Triangle$equalDetourPoint()}}
\item \href{#method-trilinearToPoint}{\code{Triangle$trilinearToPoint()}}
\item \href{#method-pointToTrilinear}{\code{Triangle$pointToTrilinear()}}
\item \href{#method-isogonalConjugate}{\code{Triangle$isogonalConjugate()}}
\item \href{#method-rotate}{\code{Triangle$rotate()}}
\item \href{#method-translate}{\code{Triangle$translate()}}
\item \href{#method-SteinerEllipse}{\code{Triangle$SteinerEllipse()}}
\item \href{#method-SteinerInellipse}{\code{Triangle$SteinerInellipse()}}
\item \href{#method-MandartInellipse}{\code{Triangle$MandartInellipse()}}
\item \href{#method-randomPoints}{\code{Triangle$randomPoints()}}
\item \href{#method-hexylTriangle}{\code{Triangle$hexylTriangle()}}
\item \href{#method-clone}{\code{Triangle$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Triangle} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$new(A, B, C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{A, B, C}}{vertices}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Triangle} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(1,0), c(1,1))
t
t$C
t$C <- c(2,2)
t
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Show instance of a triangle object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Triangle$new(c(0,0), c(1,0), c(1,1))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-flatness"></a>}}
\if{latex}{\out{\hypertarget{method-flatness}{}}}
\subsection{Method \code{flatness()}}{
Flatness of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$flatness()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A number between 0 and 1. A triangle is flat when its flatness is 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-a"></a>}}
\if{latex}{\out{\hypertarget{method-a}{}}}
\subsection{Method \code{a()}}{
Length of the side \code{BC}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$a()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-b"></a>}}
\if{latex}{\out{\hypertarget{method-b}{}}}
\subsection{Method \code{b()}}{
Length of the side \code{AC}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$b()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c"></a>}}
\if{latex}{\out{\hypertarget{method-c}{}}}
\subsection{Method \code{c()}}{
Length of the side \code{AB}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$c()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-edges"></a>}}
\if{latex}{\out{\hypertarget{method-edges}{}}}
\subsection{Method \code{edges()}}{
The lengths of the sides of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$edges()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A named numeric vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-orientation"></a>}}
\if{latex}{\out{\hypertarget{method-orientation}{}}}
\subsection{Method \code{orientation()}}{
Determine the orientation of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$orientation()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An integer: 1 for counterclockwise, -1 for clockwise, 0 for collinear.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-contains"></a>}}
\if{latex}{\out{\hypertarget{method-contains}{}}}
\subsection{Method \code{contains()}}{
Determine whether a point lies inside the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$contains(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isAcute"></a>}}
\if{latex}{\out{\hypertarget{method-isAcute}{}}}
\subsection{Method \code{isAcute()}}{
Determines whether the reference triangle is acute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$isAcute()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
`TRUE` if the triangle is acute (or right), `FALSE` otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-angleA"></a>}}
\if{latex}{\out{\hypertarget{method-angleA}{}}}
\subsection{Method \code{angleA()}}{
Angle at the vertex A.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$angleA()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The angle at the vertex A in radians.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-angleB"></a>}}
\if{latex}{\out{\hypertarget{method-angleB}{}}}
\subsection{Method \code{angleB()}}{
Angle at the vertex B.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$angleB()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The angle at the vertex B in radians.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-angleC"></a>}}
\if{latex}{\out{\hypertarget{method-angleC}{}}}
\subsection{Method \code{angleC()}}{
Angle at the vertex C.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$angleC()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The angle at the vertex C in radians.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-angles"></a>}}
\if{latex}{\out{\hypertarget{method-angles}{}}}
\subsection{Method \code{angles()}}{
The three angles of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$angles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A named vector containing the values of the angles in radians.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-X175"></a>}}
\if{latex}{\out{\hypertarget{method-X175}{}}}
\subsection{Method \code{X175()}}{
Isoperimetric point, also known as the X(175) triangle
  center; this is the center of the outer Soddy circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$X175()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VeldkampIsoperimetricPoint"></a>}}
\if{latex}{\out{\hypertarget{method-VeldkampIsoperimetricPoint}{}}}
\subsection{Method \code{VeldkampIsoperimetricPoint()}}{
Isoperimetric point in the sense of Veldkamp.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$VeldkampIsoperimetricPoint()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The isoperimetric point in the sense of Veldkamp, if it exists.
Otherwise, returns `NULL`.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-centroid"></a>}}
\if{latex}{\out{\hypertarget{method-centroid}{}}}
\subsection{Method \code{centroid()}}{
Centroid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$centroid()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-orthocenter"></a>}}
\if{latex}{\out{\hypertarget{method-orthocenter}{}}}
\subsection{Method \code{orthocenter()}}{
Orthocenter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$orthocenter()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-area"></a>}}
\if{latex}{\out{\hypertarget{method-area}{}}}
\subsection{Method \code{area()}}{
Area of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$area()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-incircle"></a>}}
\if{latex}{\out{\hypertarget{method-incircle}{}}}
\subsection{Method \code{incircle()}}{
Incircle of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$incircle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-inradius"></a>}}
\if{latex}{\out{\hypertarget{method-inradius}{}}}
\subsection{Method \code{inradius()}}{
Inradius of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$inradius()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-incenter"></a>}}
\if{latex}{\out{\hypertarget{method-incenter}{}}}
\subsection{Method \code{incenter()}}{
Incenter of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$incenter()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-excircles"></a>}}
\if{latex}{\out{\hypertarget{method-excircles}{}}}
\subsection{Method \code{excircles()}}{
Excircles of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$excircles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with the three excircles, \code{Circle} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-excentralTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-excentralTriangle}{}}}
\subsection{Method \code{excentralTriangle()}}{
Excentral triangle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$excentralTriangle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BevanPoint"></a>}}
\if{latex}{\out{\hypertarget{method-BevanPoint}{}}}
\subsection{Method \code{BevanPoint()}}{
Bevan point. This is the circumcenter of the
excentral triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$BevanPoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-medialTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-medialTriangle}{}}}
\subsection{Method \code{medialTriangle()}}{
Medial triangle. Its vertices are the mid-points of the
sides of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$medialTriangle()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-orthicTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-orthicTriangle}{}}}
\subsection{Method \code{orthicTriangle()}}{
Orthic triangle. Its vertices are the feet of the altitudes
of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$orthicTriangle()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-incentralTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-incentralTriangle}{}}}
\subsection{Method \code{incentralTriangle()}}{
Incentral triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$incentralTriangle()}\if{html}{\out{</div>}}
}

\subsection{Details}{
It is the triangle whose vertices are the intersections of the
reference triangle's angle bisectors with the respective opposite sides.
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NagelTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-NagelTriangle}{}}}
\subsection{Method \code{NagelTriangle()}}{
Nagel triangle (or extouch triangle) of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$NagelTriangle(NagelPoint = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{NagelPoint}}{logical, whether to return the Nagel point as attribute}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,-2), c(0.5,1), c(3,0.6))
lineAB <- Line$new(t$A, t$B)
lineAC <- Line$new(t$A, t$C)
lineBC <- Line$new(t$B, t$C)
NagelTriangle <- t$NagelTriangle(NagelPoint = TRUE)
NagelPoint <- attr(NagelTriangle, "Nagel point")
excircles <- t$excircles()
opar <- par(mar = c(0,0,0,0))
plot(0, 0, type="n", asp = 1, xlim = c(-1,5), ylim = c(-3,3),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(lineAB); draw(lineAC); draw(lineBC)
draw(excircles$A, border = "orange")
draw(excircles$B, border = "orange")
draw(excircles$C, border = "orange")
draw(NagelTriangle, lwd = 2, col = "red")
draw(Line$new(t$A, NagelTriangle$A, FALSE, FALSE), col = "blue")
draw(Line$new(t$B, NagelTriangle$B, FALSE, FALSE), col = "blue")
draw(Line$new(t$C, NagelTriangle$C, FALSE, FALSE), col = "blue")
points(rbind(NagelPoint), pch = 19)
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NagelPoint"></a>}}
\if{latex}{\out{\hypertarget{method-NagelPoint}{}}}
\subsection{Method \code{NagelPoint()}}{
Nagel point of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$NagelPoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GergonneTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-GergonneTriangle}{}}}
\subsection{Method \code{GergonneTriangle()}}{
Gergonne triangle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$GergonneTriangle(GergonnePoint = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{GergonnePoint}}{logical, whether to return the Gergonne point as an attribute}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The Gergonne triangle is also known as the
\emph{intouch triangle} or the \emph{contact triangle}.
This is the triangle made of the three tangency points of the incircle.
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GergonnePoint"></a>}}
\if{latex}{\out{\hypertarget{method-GergonnePoint}{}}}
\subsection{Method \code{GergonnePoint()}}{
Gergonne point of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$GergonnePoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tangentialTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-tangentialTriangle}{}}}
\subsection{Method \code{tangentialTriangle()}}{
Tangential triangle of the reference triangle.
This is the triangle formed by the lines tangent to the circumcircle of
the reference triangle at its vertices. It does not exist for a
right triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$tangentialTriangle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-symmedialTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-symmedialTriangle}{}}}
\subsection{Method \code{symmedialTriangle()}}{
Symmedial triangle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$symmedialTriangle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Triangle} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,-2), c(0.5,1), c(3,0.6))
symt <- t$symmedialTriangle()
symmedianA <- Line$new(t$A, symt$A, FALSE, FALSE)
symmedianB <- Line$new(t$B, symt$B, FALSE, FALSE)
symmedianC <- Line$new(t$C, symt$C, FALSE, FALSE)
K <- t$symmedianPoint()
opar <- par(mar = c(0,0,0,0))
plot(NULL, asp = 1, xlim = c(-1,5), ylim = c(-3,3),
     xlab = NA, ylab = NA, axes = FALSE)
draw(t, lwd = 2)
draw(symmedianA, lwd = 2, col = "blue")
draw(symmedianB, lwd = 2, col = "blue")
draw(symmedianC, lwd = 2, col = "blue")
points(rbind(K), pch = 19, col = "red")
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-symmedianPoint"></a>}}
\if{latex}{\out{\hypertarget{method-symmedianPoint}{}}}
\subsection{Method \code{symmedianPoint()}}{
Symmedian point of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$symmedianPoint()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A point.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-circumcircle"></a>}}
\if{latex}{\out{\hypertarget{method-circumcircle}{}}}
\subsection{Method \code{circumcircle()}}{
Circumcircle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$circumcircle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-circumcenter"></a>}}
\if{latex}{\out{\hypertarget{method-circumcenter}{}}}
\subsection{Method \code{circumcenter()}}{
Circumcenter of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$circumcenter()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-circumradius"></a>}}
\if{latex}{\out{\hypertarget{method-circumradius}{}}}
\subsection{Method \code{circumradius()}}{
Circumradius of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$circumradius()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BrocardCircle"></a>}}
\if{latex}{\out{\hypertarget{method-BrocardCircle}{}}}
\subsection{Method \code{BrocardCircle()}}{
The Brocard circle of the reference triangle (also known
as the seven-point circle).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$BrocardCircle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BrocardPoints"></a>}}
\if{latex}{\out{\hypertarget{method-BrocardPoints}{}}}
\subsection{Method \code{BrocardPoints()}}{
Brocard points of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$BrocardPoints()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of two points, the first Brocard point and the second
Brocard point.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LemoineCircleI"></a>}}
\if{latex}{\out{\hypertarget{method-LemoineCircleI}{}}}
\subsection{Method \code{LemoineCircleI()}}{
The first Lemoine circle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$LemoineCircleI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LemoineCircleII"></a>}}
\if{latex}{\out{\hypertarget{method-LemoineCircleII}{}}}
\subsection{Method \code{LemoineCircleII()}}{
The second Lemoine circle of the reference triangle (also
known as the cosine circle)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$LemoineCircleII()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LemoineTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-LemoineTriangle}{}}}
\subsection{Method \code{LemoineTriangle()}}{
The Lemoine triangle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$LemoineTriangle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LemoineCircleIII"></a>}}
\if{latex}{\out{\hypertarget{method-LemoineCircleIII}{}}}
\subsection{Method \code{LemoineCircleIII()}}{
The third Lemoine circle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$LemoineCircleIII()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParryCircle"></a>}}
\if{latex}{\out{\hypertarget{method-ParryCircle}{}}}
\subsection{Method \code{ParryCircle()}}{
Parry circle of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$ParryCircle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pedalTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-pedalTriangle}{}}}
\subsection{Method \code{pedalTriangle()}}{
Pedal triangle of a point with respect to the reference
triangle. The pedal triangle of a point \code{P} is the triangle whose
vertices are the feet of the perpendiculars from \code{P} to the sides
of the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$pedalTriangle(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{a point}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CevianTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-CevianTriangle}{}}}
\subsection{Method \code{CevianTriangle()}}{
Cevian triangle of a point with respect to the reference
triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$CevianTriangle(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{a point}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MalfattiCircles"></a>}}
\if{latex}{\out{\hypertarget{method-MalfattiCircles}{}}}
\subsection{Method \code{MalfattiCircles()}}{
Malfatti circles of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$MalfattiCircles(tangencyPoints = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangencyPoints}}{logical, whether to retourn the tangency points of
the Malfatti circles as an attribute.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the three Malfatti circles, \code{Circle} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
Mcircles <- t$MalfattiCircles(TRUE)
plot(NULL, asp = 1, xlim = c(0,2.5), ylim = c(0,2.5),
     xlab = NA, ylab = NA)
grid()
draw(t, col = "blue", lwd = 2)
invisible(lapply(Mcircles, draw, col = "green", border = "red"))
invisible(lapply(attr(Mcircles, "tangencyPoints"), function(P){
  points(P[1], P[2], pch = 19)
}))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AjimaMalfatti1"></a>}}
\if{latex}{\out{\hypertarget{method-AjimaMalfatti1}{}}}
\subsection{Method \code{AjimaMalfatti1()}}{
First Ajima-Malfatti point of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$AjimaMalfatti1()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AjimaMalfatti2"></a>}}
\if{latex}{\out{\hypertarget{method-AjimaMalfatti2}{}}}
\subsection{Method \code{AjimaMalfatti2()}}{
Second Ajima-Malfatti point of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$AjimaMalfatti2()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-equalDetourPoint"></a>}}
\if{latex}{\out{\hypertarget{method-equalDetourPoint}{}}}
\subsection{Method \code{equalDetourPoint()}}{
Equal detour point of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$equalDetourPoint(detour = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{detour}}{logical, whether to return the detour as an attribute}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Also known as the X(176) triangle center.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trilinearToPoint"></a>}}
\if{latex}{\out{\hypertarget{method-trilinearToPoint}{}}}
\subsection{Method \code{trilinearToPoint()}}{
Point given by trilinear coordinates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$trilinearToPoint(x, y, z)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x, y, z}}{trilinear coordinates}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The point with trilinear coordinates \code{x:y:z} with respect to
the reference triangle.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(2,1), c(5,7))
incircle <- t$incircle()
t$trilinearToPoint(1, 1, 1)
incircle$center
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pointToTrilinear"></a>}}
\if{latex}{\out{\hypertarget{method-pointToTrilinear}{}}}
\subsection{Method \code{pointToTrilinear()}}{
Give the trilinear coordinates of a point with respect to
the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$pointToTrilinear(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{a point}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The trilinear coordinates, a numeric vector of length 3.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isogonalConjugate"></a>}}
\if{latex}{\out{\hypertarget{method-isogonalConjugate}{}}}
\subsection{Method \code{isogonalConjugate()}}{
Isogonal conjugate of a point with respect to
the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$isogonalConjugate(P)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{a point}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A point, the isogonal conjugate of \code{P}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-rotate}{}}}
\subsection{Method \code{rotate()}}{
Rotate the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$rotate(alpha, O, degrees = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{angle of rotation}

\item{\code{O}}{center of rotation}

\item{\code{degrees}}{logical, whether \code{alpha} is given in degrees}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-translate"></a>}}
\if{latex}{\out{\hypertarget{method-translate}{}}}
\subsection{Method \code{translate()}}{
Translate the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$translate(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{the vector of translation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Triangle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SteinerEllipse"></a>}}
\if{latex}{\out{\hypertarget{method-SteinerEllipse}{}}}
\subsection{Method \code{SteinerEllipse()}}{
The Steiner ellipse (or circumellipse) of the reference
triangle. This is the ellipse passing through the three vertices of
the triangle and centered at the centroid of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$SteinerEllipse()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{Ellipse} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
ell <- t$SteinerEllipse()
plot(NULL, asp = 1, xlim = c(0,2.5), ylim = c(-0.7,2.4),
     xlab = NA, ylab = NA)
draw(t, col = "blue", lwd = 2)
draw(ell, border = "red", lwd =2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SteinerInellipse"></a>}}
\if{latex}{\out{\hypertarget{method-SteinerInellipse}{}}}
\subsection{Method \code{SteinerInellipse()}}{
The Steiner inellipse (or midpoint ellipse) of the reference
triangle. This is the ellipse tangent to the sides of the triangle at
their midpoints, and centered at the centroid of the triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$SteinerInellipse()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{Ellipse} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t <- Triangle$new(c(0,0), c(2,0.5), c(1.5,2))
ell <- t$SteinerInellipse()
plot(NULL, asp = 1, xlim = c(0,2.5), ylim = c(-0.1,2.4),
     xlab = NA, ylab = NA)
draw(t, col = "blue", lwd = 2)
draw(ell, border = "red", lwd =2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MandartInellipse"></a>}}
\if{latex}{\out{\hypertarget{method-MandartInellipse}{}}}
\subsection{Method \code{MandartInellipse()}}{
The Mandart inellipse of the reference triangle. This is
  the unique ellipse tangent to the triangle's sides at the contact
  points of its excircles
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$MandartInellipse()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{Ellipse} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-randomPoints"></a>}}
\if{latex}{\out{\hypertarget{method-randomPoints}{}}}
\subsection{Method \code{randomPoints()}}{
Random points on or in the reference triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$randomPoints(n, where = "in")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{an integer, the desired number of points}

\item{\code{where}}{\code{"in"} to generate inside the triangle,
\code{"on"} to generate on the triangle}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The generated points in a two columns matrix with \code{n} rows.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hexylTriangle"></a>}}
\if{latex}{\out{\hypertarget{method-hexylTriangle}{}}}
\subsection{Method \code{hexylTriangle()}}{
Hexyl triangle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$hexylTriangle()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
