% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reflection.R
\name{Reflection}
\alias{Reflection}
\title{R6 class representing a reflection}
\description{
A reflection is given by a line.
}
\examples{

## ------------------------------------------------
## Method `Reflection$new`
## ------------------------------------------------

l <- Line$new(c(1,1), c(1.5,1.5), FALSE, TRUE)
Reflection$new(l)

## ------------------------------------------------
## Method `Reflection$getMatrix`
## ------------------------------------------------

R <- Reflection$new(Line$new(c(2,2), c(4,5)))
P <- c(1,5)
R$reflect(P)
R$getMatrix() \%*\% c(P,1)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{line}}{get or set the line of the reflection}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Reflection$new()}}
\item \href{#method-print}{\code{Reflection$print()}}
\item \href{#method-reflect}{\code{Reflection$reflect()}}
\item \href{#method-transform}{\code{Reflection$transform()}}
\item \href{#method-reflectCircle}{\code{Reflection$reflectCircle()}}
\item \href{#method-transformCircle}{\code{Reflection$transformCircle()}}
\item \href{#method-reflectLine}{\code{Reflection$reflectLine()}}
\item \href{#method-transformLine}{\code{Reflection$transformLine()}}
\item \href{#method-getMatrix}{\code{Reflection$getMatrix()}}
\item \href{#method-asAffine}{\code{Reflection$asAffine()}}
\item \href{#method-clone}{\code{Reflection$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{Reflection} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$new(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Reflection} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{l <- Line$new(c(1,1), c(1.5,1.5), FALSE, TRUE)
Reflection$new(l)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
Show instance of a reflection object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reflect"></a>}}
\subsection{Method \code{reflect()}}{
Reflect a point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$reflect(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point, \code{Inf} allowed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transform"></a>}}
\subsection{Method \code{transform()}}{
An alias of \code{reflect}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$transform(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point, \code{Inf} allowed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reflectCircle"></a>}}
\subsection{Method \code{reflectCircle()}}{
Reflect a circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$reflectCircle(circ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transformCircle"></a>}}
\subsection{Method \code{transformCircle()}}{
An alias of \code{reflectCircle}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$transformCircle(circ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reflectLine"></a>}}
\subsection{Method \code{reflectLine()}}{
Reflect a line.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$reflectLine(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transformLine"></a>}}
\subsection{Method \code{transformLine()}}{
An alias of \code{reflectLine}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$transformLine(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getMatrix"></a>}}
\subsection{Method \code{getMatrix()}}{
Augmented matrix of the reflection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$getMatrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 3x3 matrix.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{R <- Reflection$new(Line$new(c(2,2), c(4,5)))
P <- c(1,5)
R$reflect(P)
R$getMatrix() \%*\% c(P,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-asAffine"></a>}}
\subsection{Method \code{asAffine()}}{
Convert the reference reflection to an \code{Affine} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$asAffine()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
