% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inversion.R
\name{Inversion}
\alias{Inversion}
\title{R6 class representing an inversion}
\description{
An inversion is given by a pole (a point) and a power (a number,
possibly negative, but not zero).
}
\examples{

## ------------------------------------------------
## Method `Inversion$print`
## ------------------------------------------------

Inversion$new(c(0,0), 2)

## ------------------------------------------------
## Method `Inversion$invertCircle`
## ------------------------------------------------

# A Pappus chain
# https://www.cut-the-knot.org/Curriculum/Geometry/InversionInArbelos.shtml
opar <- par(mar = c(0,0,0,0))
plot(0, 0, type = "n", asp = 1, xlim = c(0,6), ylim = c(-4,4),
     xlab = NA, ylab = NA, axes = FALSE)
A <- c(0,0); B <- c(6,0)
ABsqr <- c(crossprod(A-B))
iota <- Inversion$new(A, ABsqr)
C <- iota$invert(c(8,0))
Sigma1 <- Circle$new((A+B)/2, sqrt(ABsqr)/2)
Sigma2 <- Circle$new((A+C)/2, sqrt(c(crossprod(A-C)))/2)
draw(Sigma1); draw(Sigma2)
circ0 <- Circle$new(c(7,0), 1)
iotacirc0 <- iota$invertCircle(circ0)
draw(iotacirc0)
for(i in 1:6){
  circ <- circ0$translate(c(0,2*i))
  iotacirc <- iota$invertCircle(circ)
  draw(iotacirc)
  circ <- circ0$translate(c(0,-2*i))
  iotacirc <- iota$invertCircle(circ)
  draw(iotacirc)
}
par(opar)
}
\seealso{
\code{\link{inversionSwappingTwoCircles}},
\code{\link{inversionFixingTwoCircles}},
\code{\link{inversionFixingThreeCircles}} to create some inversions.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{pole}}{get or set the pole}

\item{\code{power}}{get or set the power}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Inversion$new()}}
\item \href{#method-print}{\code{Inversion$print()}}
\item \href{#method-invert}{\code{Inversion$invert()}}
\item \href{#method-transform}{\code{Inversion$transform()}}
\item \href{#method-invertCircle}{\code{Inversion$invertCircle()}}
\item \href{#method-transformCircle}{\code{Inversion$transformCircle()}}
\item \href{#method-invertLine}{\code{Inversion$invertLine()}}
\item \href{#method-transformLine}{\code{Inversion$transformLine()}}
\item \href{#method-compose}{\code{Inversion$compose()}}
\item \href{#method-clone}{\code{Inversion$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{Inversion} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Inversion$new(pole, power)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pole}}{the pole}

\item{\code{power}}{the power}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Inversion} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
Show instance of an inversion object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Inversion$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Inversion$new(c(0,0), 2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-invert"></a>}}
\subsection{Method \code{invert()}}{
Inversion of a point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Inversion$invert(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point or \code{Inf}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A point or \code{Inf}, the image of \code{M}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transform"></a>}}
\subsection{Method \code{transform()}}{
An alias of \code{invert}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Inversion$transform(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point or \code{Inf}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A point or \code{Inf}, the image of \code{M}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-invertCircle"></a>}}
\subsection{Method \code{invertCircle()}}{
Inversion of a circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Inversion$invertCircle(circ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object or a \code{Line} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# A Pappus chain
# https://www.cut-the-knot.org/Curriculum/Geometry/InversionInArbelos.shtml
opar <- par(mar = c(0,0,0,0))
plot(0, 0, type = "n", asp = 1, xlim = c(0,6), ylim = c(-4,4),
     xlab = NA, ylab = NA, axes = FALSE)
A <- c(0,0); B <- c(6,0)
ABsqr <- c(crossprod(A-B))
iota <- Inversion$new(A, ABsqr)
C <- iota$invert(c(8,0))
Sigma1 <- Circle$new((A+B)/2, sqrt(ABsqr)/2)
Sigma2 <- Circle$new((A+C)/2, sqrt(c(crossprod(A-C)))/2)
draw(Sigma1); draw(Sigma2)
circ0 <- Circle$new(c(7,0), 1)
iotacirc0 <- iota$invertCircle(circ0)
draw(iotacirc0)
for(i in 1:6){
  circ <- circ0$translate(c(0,2*i))
  iotacirc <- iota$invertCircle(circ)
  draw(iotacirc)
  circ <- circ0$translate(c(0,-2*i))
  iotacirc <- iota$invertCircle(circ)
  draw(iotacirc)
}
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transformCircle"></a>}}
\subsection{Method \code{transformCircle()}}{
An alias of \code{invertCircle}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Inversion$transformCircle(circ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object or a \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-invertLine"></a>}}
\subsection{Method \code{invertLine()}}{
Inversion of a line.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Inversion$invertLine(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object or a \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transformLine"></a>}}
\subsection{Method \code{transformLine()}}{
An alias of \code{invertLine}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Inversion$transformLine(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object or a \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-compose"></a>}}
\subsection{Method \code{compose()}}{
Compose the reference inversion with another inversion.
The result is a Möbius transformation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Inversion$compose(iota1, left = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iota1}}{an \code{Inversion} object}

\item{\code{left}}{logical, whether to compose at left or at right (i.e.
returns \code{iota1 o iota0} or \code{iota0 o iota1})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Mobius} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Inversion$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
