% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markDelivery.R
\name{markDelivery}
\alias{markDelivery}
\title{Classify Mail Delivery and Non-Delivery Days for Accelerometer Data}
\usage{
markDelivery(data, cts = getOption("pa.cts"), markingString = "w",
  window = c("trim", "consecutive", "valid"), method = c("95", "mean",
  "sd"), validCut = getOption("pa.validCut"), wearThreshold = 300,
  dist = c("t", "normal"))
}
\arguments{
\item{data}{Data with classified wear (nonwear) status by
\code{\link{wearingMarking}}.}

\item{cts}{The name of the counts column. The default is \dQuote{axis1}.}

\item{markingString}{Option for summarizing wear (markingString = \dQuote{w}) or
nonwear time (markingString = \dQuote{nw}).}

\item{window}{A character. It should be one of \sQuote{trim}, \sQuote{consecutive}, 
or \sQuote{valid}.}

\item{method}{A character. It should be one of \sQuote{95}, \sQuote{mean} or \sQuote{sd}.}

\item{validCut}{A cutoff for the total minutes of classified monitor wear
time per day to be considered as a valid monitor day.}

\item{wearThreshold}{A numeric value specifying a pseudo-valid day cutoff
similar to \dQuote{validCut}, which is used to define a set of days to estimate
the 95\% CI.}

\item{dist}{Option for distribution used to calculate the 95\% CI.}
}
\value{
A data frame with summary information about daily counts.
}
\description{
This function adds an indicator variable for accelerometer delivery days based
on a delivery classification algorithm. The algorithm classifies each day as 
delivery or non-delivery day within each participant data using summary 
statistics of accelerometer counts for each day. As the summary statistics,
the 95th percentile, mean and standard deviation (sd) of accelerometer counts
can be used. Using the summary statistics for each day, the algorithm defines
a set of days that are used to estimate the 95\% confidence interval (CI)
based on t-distribution (default) or normal distribution. The lower bound of
the 95\%  CI is used to classify delivery days; if the summary statistics 
for a day is below the lower bound of the 95\% CI, this day is classified 
as delivery day. Three methods for defining a set of days are available: 
\code{trim} (default), \code{consecutive}, and \code{valid}.
}
\examples{
data(deliveryData)

options(pa.cts = "vm")
wm <- wearingMarking(dataset = deliveryData)

markDelivery(wm)
plotData(data=wm) # days 1, 2, 10 - 15 are delivery or invalid days based on the result above
markDelivery(wm, window='valid', method='mean')
markDelivery(wm, method='mean')
markDelivery(wm, method='sd')
}
\author{
Cole Beck \email{cole.beck@vumc.org},
Leena Choi \email{leena.choi@Vanderbilt.Edu}
}
