% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeSensitivityProfiles.R
\name{summarizeSensitivityProfiles}
\alias{summarizeSensitivityProfiles}
\title{Takes the sensitivity data from a PharmacoSet, and summarises them into a
drug vs cell line table}
\usage{
summarizeSensitivityProfiles(pSet, sensitivity.measure = c("gi50_published",
  "ic50_published", "auc_published", "ic50_recomputed", "auc_recomputed",
  "auc_recomputed_star", "Synergy_score", "amax_published", "amax_recomputed",
  "slope_recomputed"), cell.lines, drugs, summary.stat = c("mean", "median",
  "first", "last"), fill.missing = TRUE, verbose = TRUE)
}
\arguments{
\item{pSet}{[PharmacoSet] The PharmacoSet from which to extract the data}

\item{sensitivity.measure}{[character] which sensitivity sensitivity.measure to use? The current
choices are 'gi50_published', 'ic50_published', 'ic50_recomputed',
'auc_published', auc_recomputed', 'auc_recomputed_star',
 'amax_published', 'amax_recomputed',
 'Synergy_score' and 'slope_recomputed'.}

\item{cell.lines}{\code{character} The cell lines to be summarized. 
 If any cell lines has no data, it will be filled with
missing values}

\item{drugs}{\code{character} The drugs to be summarized.
If any drugs has no data, it will be filled with
missing values}

\item{summary.stat}{\code{character} which summary method to use if there are repeated
cell line-drug experiments? Choices are "mean", "median", "first", or "last"}

\item{fill.missing}{\code{boolean} should the missing cell lines not in the
molecular data object be filled in with missing values?}

\item{verbose}{Should the function print progress messages?}
}
\value{
[matrix] A matrix with cell lines going down the rows, drugs across
  the columns, with the selected sensitivity statistic for each pair.
}
\description{
This function creates a table with cell lines as rows and drugs as columns,
summarising the drug senstitivity data of a PharmacoSet into drug-cell line
pairs
}
\examples{
data(GDSCsmall)
GDSCauc <- summarizeSensitivityProfiles(GDSCsmall, sensitivity.measure='auc_published')

}

