% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atomRecognition.R
\name{atomRecognition}
\alias{areSymb}
\alias{atomRecognition}
\alias{isSymb}
\alias{symb}
\title{Atom Recognition}
\usage{
symb(x, na.as.dummy = FALSE)

areSymb(x, na.action = FALSE)

isSymb(x, na.action = FALSE)
}
\arguments{
\item{x}{an R object for which to determine atomic symbols or to be tested.}

\item{na.as.dummy}{a logical value. Whether to consider \code{NA} values as
dummy atoms or not.}

\item{na.action}{a logical value or \code{NA}. \code{NA} values will be set to this value.}
}
\value{
\code{symb} returns a character vector containing atomic symbols.
  \code{areSymb} returns a logical vector. \code{isSymb} returns TRUE if
  \code{x} contains only atomic symbols or \code{FALSE} otherwise.
}
\description{
Determine atomic symbols from atom names or atomic numbers.
}
\details{
In some files, atom names/types are specified instead of atomic symbols. It
is then useful to convert atom names/types into atomic symbols. The
\code{symb} function allow to perform this convertion by using the
\code{\link{atomNames}} and \code{\link{periodicTable}} data sets.

Atom recognition from character vector is performed as follow: \itemize{
\item Remove numbers from character strings. \item Search for matching atom
types in \code{\link{atomNames}} dataset. \item Truncate to first character
and translate to upper case. \item Search for matching atomic symbols in
\code{\link{periodicTable}} dataset. \item Unrecognized atoms are considered as
dummy atoms (\code{"Xx"}).}

Function \code{symb} can also convert atomic numbers into atomic symbols.
Atomic numbers are first checked to be whole numbers and then searched into
the \code{\link{periodicTable}} dataset to determine atomic symbols.

Function \code{areSymb} can be used to check if the values in a vector are
atomic symbols.\cr Function \code{isSymb} can be used to check if all the
values in a vector are atomic symbols.
}
\examples{
# Display atomNames
data(atomNames)
atomNames

# Get atomic symbols from atom names
symb(c("CA", "CB", "N", "NZ", "OXT"))

# Get atomic symbols from atomic numbers
symb(1:4)

}
\seealso{
\code{\link{atomNames}}, \code{\link{periodicTable}},
  \code{\link{atomProperties}}, \code{\link[base]{match}}
}
\keyword{utilities}

