`BetaCoSkewness` <-
function(Ra, Ri, na.rm=FALSE)
{ # @author Brian G. Peterson

    # Description:
    # Beta CoSkewness is the beta of an asset to the skewness
    # of an initial portfolio.  Used to determine diversification potential.
    # also called "systematic skewness" or "systematic co-skewness"
    # by several papers.
    # as defined in
    # Favre, L. and Renaldo, A., October 2003
    # How to Price Hedge Funds: From Two- to Four-Moment CAPM
    # UBS and Edhec Business School
    # Equation [5] p. 10

    # Ri = return vector of initial portfolio
    # Ra = return vector of asset being considered for addition to portfolio

    # Setup

    Ri = checkDataVector(Ri)
    Ra = checkDataVector(Ra)

    if(na.rm) {
        Ri <- Ri[!is.na(Ri)]
        Ra <- Ra[!is.na(Ra)]
    }

    # FUNCTION:

    # systematic skewness of two assets
    # skB = CoSkewness(Ra,Ri)/(sum((Ri-mean(Ri))^3))
    skB = CoSkewness(Ra,Ri)/skewness(Ra)

    result = skB

    # Return Value:
    result
}

###############################################################################

`BetaCoS` <-
function(Ri, Ra, na.rm=FALSE)
{
    # wrapper function with a shorter name
    result = BetaCoSkewness(Ri, Ra, na.rm)
    # Return Value:
    result
}

###############################################################################

`SystematicSkewness` <-
function(Ri, Ra, na.rm=FALSE)
{
    # wrapper function with a shorter name
    result = BetaCoSkewness(Ri, Ra, na.rm)
    # Return Value:
    result
}

###############################################################################
# R (http://r-project.org/) Econometrics for Performance and Risk Analysis
#
# Copyright (c) 2004-2007 Peter Carl and Brian G. Peterson
#
# This library is distributed under the terms of the GNU Public License (GPL)
# for full details see the file COPYING
#
# $Id: BetaCoSkewness.R,v 1.5 2007/03/11 16:58:07 brian Exp $
#
###############################################################################
# $Log: BetaCoSkewness.R,v $
# Revision 1.5  2007/03/11 16:58:07  brian
# - replace as.vector() with checkDataVector()
#
# Revision 1.4  2007/03/11 16:53:19  brian
# - add equations and text to documentation
# - standardize on Ra as the Return of the Asset
# - standardize on Ra as first argument where that wasn't previously true
#
# Revision 1.3  2007/02/08 21:38:52  brian
# - correct pervasive calculation error in co-moments
#
# Revision 1.2  2007/02/07 13:24:49  brian
# - fix pervasive comment typo
#
# Revision 1.1  2007/02/02 19:06:15  brian
# - Initial Revision of packaged files to version control
# Bug 890
#
###############################################################################