% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conductance.R
\name{individualDomProb}
\alias{individualDomProb}
\title{individual-level probability converter}
\usage{
individualDomProb(matrix)
}
\arguments{
\item{matrix}{the win-loss matrix which is the second output from \code{conductance}.}
}
\value{
a dataframe. Averaging probability of win-loss relationship with all other individuals.
}
\description{
\code{individualDomProb} convert win-loss probability matrix into long format for each dyad
}
\examples{
# convert an edgelist to conflict matrix
confmatrix <- as.conflictmat(sampleEdgelist)
# find win-loss probability matrix
perm2 <- conductance(confmatrix, 2)
perm2$imputed.conf
perm2$p.hat
individualLevelOutput <- individualDomProb(perm2$p.hat)
}
\seealso{
\code{\link{conductance}}, \code{\link{valueConverter}}, \code{\link{dyadicLongConverter}}
}
