\name{Gpoly, Gnormed.poly}
\alias{Gpoly}
\alias{Gnormed.poly}
\title{Number of Guttman errors for polytomous items}
\description{Molenaar (1991) and Emons (2008) statistics, based on the number of Guttman errors, for polytomous items.}

\usage{
Gpoly(matrix, Ncat, 
     NA.method = "Pairwise", Save.MatImp = FALSE, 
     IP = NULL, IRT.PModel = "GRM", Ability = NULL, Ability.PModel = "EAP")

Gnormed.poly(matrix, Ncat, 
             NA.method = "Pairwise", Save.MatImp = FALSE,
             IP = NULL, IRT.PModel = "GRM", Ability = NULL, Ability.PModel = "EAP")
}

\arguments{
  \item{matrix}{A data matrix of polytomous item scores: Persons as rows, items as columns, item scores are integers between 0 and (Ncat-1), missing values allowed.}
  \item{Ncat}{Number of answer options for each item.}
  \item{NA.method}{Method to deal with missing values. The default is pairwise elimination (\code{"Pairwise"}). Alternatively, simple imputation methods are also available. The options available are \code{"Hotdeck"}, \code{"NPModel"} (default), and \code{"PModel"}.}
  \item{Save.MatImp}{Logical. Save (imputted) data matrix to file? Default is FALSE.}
  \item{IP}{Matrix with previously estimated item parameters: One row per item. The first (Ncat-1) columns contain the between-categories threshold parameters (for the GRM) or the item step difficulties (for the PCM and the GPCM). The last, Ncat-th, column has the slopes.
  
  In case no item parameters are available then \code{IP=NULL}.}
  \item{IRT.PModel}{Specify the IRT model to use in order to estimate the item parameters (only if \code{IP=NULL}). The options available are \code{"PCM"}, \code{"GPCM"}, and \code{"GRM"} (default).}
  \item{Ability}{Vector with previoulsy estimated latent ability parameters, one per respondent, following the order of the row index of \code{matrix}.
  
  In case no ability parameters are available then \code{Ability=NULL}.}
  \item{Ability.PModel}{Specify the method to use in order to estimate the latent ability parameters (only if \code{Ability=NULL}). The options available are \code{"EB"}, \code{"EAP"} (default), and \code{"MI"}.}
}

\details{
Molenaar (1991) generalized the \code{G} person-fit statistic to polytomous items, \code{Gpoly}. The idea is based on the so-called item-step difficulty, which is the probability of moving from answer category \eqn{(c)} to answer category \eqn{(c+1)} (\eqn{c=0,\ldots,Ncat-2}{c=0,...,Ncat-2}).

Just like \code{G}, \code{Gpoly} depends on the test length. Emons (2008) developed \code{Gnormed.poly}, which is a normalized version of \code{Gpoly}.

Aberrant response behavior is (potentially) indicated by large values of Gpoly/Gnormed.poly (i.e., in the right tail of the sampling distribution).

The number of answer options, \code{Ncat}, is the same for all items.

\code{Gpoly} reduces to \code{G}, and \code{Gnormed.poly} reduces to \code{Gnormed}, when \code{Ncat=2}.

Missing values in \code{matrix} are dealt with by means of pairwise elimination by default. Alternatively, single imputation is also available. Three single imputation methods exist: Hotdeck imputation (\code{NA.method = "Hotdeck"}), nonparametric model imputation (\code{NA.method = "NPModel"}), and parametric model imputation (\code{NA.method = "PModel"}); see Zhang and Walker (2008). 
\itemize{
\item Hotdeck imputation replaces missing responses of an examinee ('recipient') by item scores from the examinee which is closest to the recipient ('donor'), based on the recipient's nonmissing item scores. The similarity between nonmissing item scores of recipients and donors is based on the sum of absolute differences between the corresponding item scores. The donor's response pattern is deemed to be the most similar to the recipient's response pattern in the group, so item scores of the former are used to replace the corresponding missing values of the latter. When multiple donors are equidistant to a recipient, one donor is randomly drawn from the set of all donors.
\item The nonparametric model imputation method is similar to the hotdeck imputation, but item scores are generated from multinomial distributions with probabilities defined by donors with similar total score than the recipient (based on all items except the NAs).
\item The parametric model imputation method is similar to the hotdeck imputation, but item scores are generated from multinomial distributions with probabilities estimated by means of parametric IRT models (\code{IRT.PModel = "PCM"}, \code{"GPCM"}, or \code{"GRM"}). Item parameters (\code{IP}) and ability parameters (\code{Ability}) may be provided for this purpose (otherwise the algorithm finds estimates for these parameters).
}
}

\value{
An object of class "PerFit", which is a list with 12 elements:
  \item{PFscores}{A list of length \eqn{N} (number of respondents) with the values of the person-fit statistic.}
  \item{PFstatistic}{The person-fit statistic used.}
  \item{PerfVects}{Not applicable.}
  \item{ID.all0s}{Not applicable.}
  \item{ID.all1s}{Not applicable.}
  \item{matrix}{The data matrix after imputation of missing values was performed (if applicable).}
  \item{Ncat}{The number of response categories.}
  \item{IRT.PModel}{The parametric IRT model used.}
  \item{IP}{The \eqn{I}xNcat matrix of estimated item parameters.}
  \item{Ability.PModel}{The method used to estimate abilities used.}
  \item{Ability}{The vector of \eqn{N} estimated ability parameters.}
  \item{NAs.method}{The imputation method used (if applicable).}
}

\references{
Emons, W. M. (2008) Nonparametric person-fit analysis of polytomous item scores. \emph{Applied Psychological Measurement}, \bold{32(3)}, 224--247. 

Karabatsos, G. (2003) Comparing the Aberrant Response Detection Performance of Thirty-Six Person-Fit Statistics. \emph{Applied Measurement In Education}, \bold{16(4)}, 277--298.

Meijer, R. R. (1994) The number of Guttman errors as a simple and powerful person-fit statistic. \emph{Applied Psychological Measurement}, \bold{18(4)}, 311--314.

Molenaar, I. W. (1991) A weighted Loevinger H-coefficient extending Mokken scaling to multicategory items. \emph{Kwantitatieve Methoden}, \bold{12(37)}, 97--117.

Zhang, B., and Walker, C. M. (2008) Impact of missing data on person-model fit and person trait estimation. \emph{Applied Psychological Measurement}, \bold{32(6)}, 466--479.
}
\author{Jorge N. Tendeiro \email{tendeiro@hiroshima-u.ac.jp}}
\seealso{\code{\link{G}}, \code{\link{Gnormed}}}
\examples{
# Load the physical functioning data (polytomous item scores):
data(PhysFuncData)

# Compute the Gpoly scores:
Gpoly.out <- Gpoly(PhysFuncData, Ncat=3)

# Compute the Gnormed.poly scores:
Gnormedpoly.out <- Gnormed.poly(PhysFuncData, Ncat=3)
}
\keyword{univar}
