% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_array.R
\docType{methods}
\name{unionMicro-methods}
\alias{unionMicro-methods}
\alias{unionMicro}
\alias{unionMicro,micro_array,micro_array-method}
\alias{unionMicro,list,ANY-method}
\title{Makes the union between two micro_array objects.}
\usage{
\S4method{unionMicro}{micro_array,micro_array}(M1, M2)
}
\arguments{
\item{M1}{a micro-array or a list of micro-arrays}

\item{M2}{a micro-array or nothing if M1 is a list of micro-arrays}
}
\description{
Makes the union between two micro_array objects.
}
\section{Methods}{
 \describe{

\item{list("signature(M1 = \"micro_array\", M2 = \"micro_array\")")}{
Returns a micro_array object which is the union of M1 and M2.  }

\item{list("signature(M1 = \"list\", M2 = \"ANY\")")}{ Returns a micro_array
object which is the union of the elements of M1.  } }
}

\examples{

if(require(CascadeData)){
data(micro_S, package="CascadeData")
#Create another microarray object with 100 genes
Mbis<-M<-as.micro_array(micro_S[1:100,],1:4,6)
#Rename the 100 genes
Mbis@name<-paste(M@name,"bis")
rownames(Mbis@microarray) <- Mbis@name
#Union (merge without duplicated names) of the two microarrays. 
str(unionMicro(M,Mbis))
}

}
\author{
Bertrand Frederic, Myriam Maumy-Bertrand.
}
\keyword{methods}
