% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceDecay.R
\name{linearDecay}
\alias{linearDecay}
\title{A simple linear decay function.}
\usage{
linearDecay(x, signal, ...)
}
\arguments{
\item{x}{A numeric vector of distances (in [0,1]).}

\item{signal}{A single numeric value representing a signal.}

\item{...}{Not used; argument implemented for call compatibility with
\code{\link{weibullDecay}} and \code{\link{expDecay}} functions.}
}
\value{
A numeric vector.
}
\description{
The \code{linearDecay} function is used by PathwaySpace's
methods for signal convolution and projection.
}
\examples{
x <- c(1:100) / 100
y <- linearDecay(x, 1)
plot(x, y)

}
\seealso{
\code{\link{weibullDecay}}, \code{\link{expDecay}}
}
\author{
Vinicius Chagas, Victor Apolonio, and
Mauro Castro (\email{mauro.castro@ufpr.br})
}
