% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeIDs.R
\name{remove.ids}
\alias{remove.ids}
\title{Removes IDs with NA in a list of adjacency matrices optimally}
\usage{
remove.ids(network, ncores = 1L)
}
\arguments{
\item{network}{is a list of adjacency matrices}

\item{ncores}{is the number of cores to be used to run the program in parallel}
}
\value{
List of adjacency matrices without missing values and a list of vectors of retained indeces
}
\description{
The function optimally removes identifiers with NA in a list of adjacency matrices. Many combinations of rows and columns can be deleted
removing many rows and column
}
\examples{
A <- matrix(1:25, 5)
A[1, 1] <- NA
A[4, 2] <- NA
remove.ids(A)

B <- matrix(1:100, 10)
B[1, 1] <- NA
B[4, 2] <- NA
B[2, 4] <- NA
B[,8]   <-NA
remove.ids(B)
}
