#' @rdname LearnerParam
#' @export
makeNumericLearnerParam = function(id, lower = -Inf, upper = Inf, default,
  when = "train", requires = NULL) {

  p = makeNumericParam(id, lower, upper, default = default, requires = requires)
  learnerParamFromParam(p, when)
}

#' @rdname LearnerParam
#' @export
makeNumericVectorLearnerParam = function(id, len = as.integer(NA), lower = -Inf,
  upper = Inf, default, when = "train", requires = NULL) {

  len = asInt(len, na.ok = TRUE)
  if (is.na(len))
    p = makeNumericVectorParam(id, len = 1, lower = lower, upper = upper, default = default, requires = requires)
  else
    p = makeNumericVectorParam(id, len = len, lower = lower, upper = upper, default =  default, requires = requires)
  p = learnerParamFromParam(p, when)
  p$len = len
  return(p)
}


#' @rdname LearnerParam
#' @export
makeIntegerLearnerParam = function(id, lower = -Inf, upper = Inf,
  default, when = "train", requires = NULL) {

  p = makeIntegerParam(id, lower, upper, default = default, requires = requires)
  learnerParamFromParam(p, when)
}

#' @rdname LearnerParam
#' @export
makeIntegerVectorLearnerParam = function(id, len = as.integer(NA), lower = -Inf,
  upper = Inf, default, when = "train", requires = NULL) {

  len = asInt(len, na.ok = TRUE)
  if (is.na(len))
    p = makeIntegerVectorParam(id, len = 1, lower = lower, upper = upper, default = default, requires = requires)
  else
    p = makeIntegerVectorParam(id, len = len, lower = lower, upper = upper, default = default, requires = requires)
  p = learnerParamFromParam(p, when)
  p$len = len
  return(p)
}

#' @rdname LearnerParam
#' @export
makeDiscreteLearnerParam = function(id, values, default,
  when = "train", requires = NULL) {

  p = makeDiscreteParam(id, values, default = default, requires = requires)
  learnerParamFromParam(p, when)
}

#' @rdname LearnerParam
#' @export
makeDiscreteVectorLearnerParam = function(id, len = as.integer(NA), values, default,
  when = "train", requires = NULL) {

  len = asInt(len, na.ok = TRUE)
  if (is.na(len))
    p = makeDiscreteVectorParam(id, len = 1, values = values, default = default, requires = requires)
  else
    p = makeDiscreteVectorParam(id, len = len, values = values, default = default, requires = requires)
  p = learnerParamFromParam(p, when)
  p$len = len
  return(p)
}

#' @rdname LearnerParam
#' @export
makeLogicalLearnerParam = function(id, default, when = "train",
  requires = NULL) {

  p = makeLogicalParam(id, default = default, requires = requires)
  learnerParamFromParam(p, when)
}

#' @rdname LearnerParam
#' @export
makeLogicalVectorLearnerParam = function(id, len = as.integer(NA), default, when = "train",
  requires = NULL) {

  len = asInt(len, na.ok = TRUE)
  if (is.na(len))
    p = makeLogicalVectorParam(id, len = 1, default = default, requires = requires)
  else
    p = makeLogicalVectorParam(id, len = len, default = default, requires = requires)
  p = learnerParamFromParam(p, when)
  p$len = len
  return(p)
}

#' @rdname LearnerParam
#' @export
makeUntypedLearnerParam = function(id, default, when = "train", requires = NULL) {
  p = makeUntypedParam(id, default = default, requires = requires)
  learnerParamFromParam(p, when)
}

#' @rdname LearnerParam
#' @export
makeFunctionLearnerParam = function(id, default, when = "train", requires = NULL) {
  p = makeFunctionParam(id, default = default, requires = requires)
  learnerParamFromParam(p, when)
}

learnerParamFromParam = function(p, when) {
  assertChoice(when, c("train", "predict", "both"))
  makeLearnerParam(p, when)
}
