% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ParallelPC.R
\name{pc_stable}
\alias{pc_stable}
\title{Estimate the Equivalence Class of a DAG using the PC_stable Algorithm}
\usage{
pc_stable(suffStat, indepTest, alpha, labels, p, fixedGaps = NULL,
  fixedEdges = NULL, NAdelete = TRUE, m.max = Inf, u2pd = c("relaxed",
  "rand", "retry"), skel.method = c("stable", "original", "stable.fast"),
  conservative = FALSE, maj.rule = FALSE, solve.confl = FALSE,
  verbose = FALSE)
}
\arguments{
\item{suffStat}{A list of sufficient statistics, containing all necessary elements for the conditional independence decisions in the function indepTest.}

\item{indepTest}{A function for testing conditional independence. It is internally called as indepTest(x,y,S,suffStat), and tests conditional independence of x and y given S. Here, x and y are variables, and S is a (possibly empty) vector of variables (all variables are denoted by their column numbers in the adjacency matrix). suffStat is a list, see the argument above. The return value of indepTest is the p-value of the test for conditional independence.}

\item{alpha}{significance level (number in (0,1) for the individual conditional independence tests.}

\item{labels}{(optional) character vector of variable (or "node") names. Typically preferred to specifying p.}

\item{p}{(optional) number of variables (or nodes). May be specified if labels are not, in which case labels is set to 1:p.}

\item{fixedGaps}{A logical matrix of dimension p*p. If entry [i,j] or [j,i] (or both) are TRUE, the edge i-j is removed before starting the algorithm. Therefore, this edge is guaranteed to be absent in the resulting graph.}

\item{fixedEdges}{A logical matrix of dimension p*p. If entry [i,j] or [j,i] (or both) are TRUE, the edge i-j is never considered for removal. Therefore, this edge is guaranteed to be present in the resulting graph.}

\item{NAdelete}{If indepTest returns NA and this option is TRUE, the corresponding edge is deleted. If this option is FALSE, the edge is not deleted.}

\item{m.max}{Maximal size of the conditioning sets that are considered in the conditional independence tests.}

\item{u2pd}{String specifying the method for dealing with conflicting information when trying to orient edges (see pcalg for details).}

\item{skel.method}{Character string specifying method; the default, "stable" provides an order-independent skeleton.}

\item{conservative}{Logical indicating if the conservative PC is used. In this case, only option u2pd = "relaxed" is supported. See pcalg for more information.}

\item{maj.rule}{Logical indicating that the triples shall be checked for ambiguity using a majority rule idea, which is less strict than the conservative PC algorithm. For more information, see the pcalg package.}

\item{solve.confl}{If TRUE, the orientation of the v-structures and the orientation rules work with lists for candidate sets and allow bi-directed edges to resolve conflicting edge orientations. In this case, only option u2pd = relaxed is supported. Note, that therefore the resulting object might not be a CPDAG because bi-directed edges might be present. See details for more information.}

\item{verbose}{If TRUE, detailed output is provided.}
}
\value{
An object of class "pcAlgo" (see pcAlgo in the pcalg package) containing an estimate of the equivalence class of the underlying DAG.
}
\description{
Estimate the equivalence class of a directed acyclic graph (DAG) from observational data, using the PC_stable algorithm.
}
\examples{
##########################################
## Using pc_stable
##########################################
library(pcalg)
library(parallel)
data("gmG")
p<-ncol(gmG$x)
suffStat<-list(C=cor(gmG$x),n=nrow(gmG$x))
pc_stable(suffStat, indepTest=gaussCItest, p=p, skel.method="stable", alpha=0.01)
}

