% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ParallelPC.R
\name{pcSelect_stable}
\alias{pcSelect_stable}
\title{Estimate subgraph around a response variable using pcSelect}
\usage{
pcSelect_stable(y, dm, alpha, corMethod = "standard", method = "stable",
  verbose = FALSE, directed = FALSE)
}
\arguments{
\item{y}{The target (response) variable.}

\item{dm}{Data matrix with rows are samples and columns are variables.}

\item{alpha}{Significance level of individual partial correlation tests.}

\item{corMethod}{"standard" or "Qn" for standard or robust correlation estimation}

\item{method}{Character string specifying method; the default, "stable" provides an Order-independent version.}

\item{verbose}{Logical or in \{0,1,2\};

       FALSE, 0: No output,

       TRUE, 1: Little output,

       2: Detailed output.

       Note that such output makes the function very much slower.}

\item{directed}{Logical; should the output graph be directed?}
}
\value{
G    A logical vector indicating which column of dm is associated with y.

zMin   The minimal z-values when testing partial correlations between y and each column of dm. The larger the number, the more consistent is the edge with the data.
}
\description{
This is the stable version (order independent version) of the pcSelect function (pc-Simple algorithm) in the pcalg package.
}
\examples{
##########################################
## Using pcSelect_stable
##########################################
library(pcalg)
library(parallel)
p <- 10
set.seed(101)
myDAG <- randomDAG(p, prob = 0.2)
n <- 1000
d.mat <- rmvDAG(n, myDAG, errDist = "normal")
pcSelect_stable(d.mat[,10],d.mat[,-10], alpha=0.05)
}

