% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ParallelPC.R
\name{IDA_parallel}
\alias{IDA_parallel}
\title{Estimate  Total Causal Effects  using the IDA_parallel Algorithm}
\usage{
IDA_parallel(datacsv, cause, effect, pcmethod, alpha, num.cores,
  mem.efficient = FALSE)
}
\arguments{
\item{datacsv}{The dataset in csv format.}

\item{cause}{The number of integer positions of the cause variables in the dataset.}

\item{effect}{The number of integer  positions of the target variables  in the dataset.}

\item{pcmethod}{Character string specifying method; the default, "parallel", will use the parallelised method for learning the skeleton of the graph, see skeleton_parallel.}

\item{alpha}{significance level (number in (0; 1) for the individual conditional independence tests.}

\item{num.cores}{The numbers of cores CPU to run the algorithm}

\item{mem.efficient}{If TRUE, uses less amount of memory at any time point while running the algorithm}
}
\value{
A matrix that shows the causal effects (minimum of all possible effects) of the causes (columns) on the effects (rows)
}
\description{
This is the parallelised version of the IDA (stable) algorithm in the pcalg package.
}
\examples{
##########################################
## Using IDA_parallel without mem.efficeient
##########################################
library(bnlearn)
library(pcalg)
library(parallel)
data("gmI")
datacsv <- cov(gmI$x)
IDA_parallel(datacsv,1:2,3:4,"parallel",0.01, 2)

##########################################
## Using IDA_parallel with mem.efficeient
##########################################
library(bnlearn)
library(pcalg)
library(parallel)
data("gmI")
datacsv <- cov(gmI$x)
IDA_parallel(datacsv,1:2,3:4,"parallel",0.01, 2, TRUE)
}
\references{
Marloes H Maathuis, Markus Kalisch, Peter Buhlmann, et al. Estimating high-dimensional
intervention effects from observational data. The Annals of Statistics, 37(6A):3133-3164,2009.
}

