% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Loggers.R
\name{createLogger}
\alias{createLogger}
\title{Create a logger}
\usage{
createLogger(
  name = "SIMPLE",
  threshold = "INFO",
  appenders = list(createConsoleAppender())
)
}
\arguments{
\item{name}{A name for the logger.}

\item{threshold}{The threshold to be used for reporting.}

\item{appenders}{A list of one or more appenders as created for example using the
\code{\link{createConsoleAppender}} or \code{\link{createFileAppender}} function.}
}
\value{
An object of type \code{Logger}, to be used with the \code{\link{registerLogger}} function.
}
\description{
Create a logger
}
\details{
Creates a logger that will log messages to its appenders. The logger will only log messages at a
level equal to or higher than its threshold. For example, if the threshold is "INFO" then messages
marked "INFO" will be logged, but messages marked "TRACE" will not. The order of levels is "TRACE",
"DEBUG", "INFO", "WARN", "ERROR, "and FATAL".
}
\examples{
appender <- createConsoleAppender(layout = layoutTimestamp)

logger <- createLogger(name = "SIMPLE",
                       threshold = "INFO",
                       appenders = list(appender))
registerLogger(logger)                      
logTrace("This event is below the threshold (INFO)")
logInfo("Hello world")                       
unregisterLogger("SIMPLE")                     
}
