% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelData.R
\name{PanelData}
\alias{PanelData}
\title{Pre-process and balance panel data}
\usage{
PanelData(panel.data, unit.id, time.id, treatment, outcome)
}
\arguments{
\item{panel.data}{A \code{data.frame} object containing time series cross sectional data. 
Time data should be sequential integers that increase by 1. Unit identifiers must be integers. Treatment data must be binary. If time data is non-integer, the package will attempt to sensibly convert it by converting the data to factor, then to integer. If a conversion is performed, a mapping will be returned as an attribute called "time.data.map"}

\item{unit.id}{A character string indicating the name of unit identifier in the data. This data must be integer.}

\item{time.id}{A character string indicating the name of the time variable in the data.}

\item{treatment}{A character string indicating the name of the treatment variable.
The treatment must be a binary indicator variable (integer with 0 for the control group and 1 for the treatment group).}

\item{outcome}{A character string identifying the outcome variable}
}
\value{
\code{PanelData()} returns an object of class \code{PanelData}. This takes the form of a \code{data.frame} object with the following properties and attributes. First, the data has been balanced and sorted. These properties are noted in the "is.balanced" and "is.sorted" attributes, respectively. So, each unit appears the same number of times in the resulting \code{PanelData} object, with NAs filling out missing data. Second, the data has been sorted to appear in order for each unit. Next, the \code{PanelData} object has the following attributes: "unit.id", "time.id", "treatment", and "outcome" reflecting the variables provided in the specification. If the function attempts to automatically convert time data to be consecutive integers, the mapping between the original time data and the "new" converted time data is provided as a \code{data.frame} object and stored as the "time.data.map" attribute.
}
\description{
Pre-process and balance panel data
}
\examples{
d <- PanelData(panel.data = dem, 
               unit.id = "wbcode2", 
               time.id = "year", 
               treatment = "dem", 
               outcome = "y")
}
