% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.pandemicEstimated.R
\name{posterior_predict.pandemicEstimated}
\alias{posterior_predict.pandemicEstimated}
\title{Draw from the posterior predictive distribution for pandemic data}
\usage{
\method{posterior_predict}{pandemicEstimated}(object, horizonLong = 500, horizonShort = 14, ...)
}
\arguments{
\item{object}{An object of class \code{pandemicEstimated} created by function \code{\link{pandemic_model}}.}

\item{horizonLong}{How far into the future the long-term prediction is desired.}

\item{horizonShort}{How far into the future the short-term prediction is desired.}

\item{...}{Currently unused.}
}
\value{
An object of class \code{pandemicPredicted}. It includes the sampled predictive distribution
the model used to predict, which is the same as the one used to estimate the data. This object can be used
directly into the plot function and contains the following elements:
\item{\code{predictive_Long}}{
  A \code{M x horizonLong} matrix with the full sample of the predictive distribution
  for the long-term prediction, where M is the sample size.
  The prediction is for daily new cases.
  }
  \item{\code{predictive_Short}}{
  A \code{M x horizonShort} matrix with the full sample of the predictive distribution
  for the short-term prediction, where M is the sample size.
  The prediction is for daily cumulative cases.
  }
  \item{\code{data}}{
  The data passed on from the \code{\link{pandemicEstimated-objects}} under the element \code{Y$data}.
  }
  \item{\code{location}}{
  A string with the name of the location.
  }
  \item{\code{cases_type}}{
  A string with either "confirmed" or "deaths" to represent the type of data that has been fitted and predicted.
  }
  \item{\code{pastMu}}{
  The fitted means of the data for the observed data points.
  }
  \item{\code{futMu}}{
  The predicted means of the data for the predicted data points.
  }
Function \code{\link{pandemic_stats}} provides a few useful statistics based on the predictions.
}
\description{
The posterior predictive distribution is the distribution of the outcome
implied by the model after using the observed data to update our beliefs
about the unknown parameters in the model. Simulating data from the posterior
predictive distribution using the observed predictors is useful for checking
the fit of the model. Drawing from the posterior predictive distribution at
interesting values of the predictors also lets us visualize how a manipulation
of a predictor affects (a function of) the outcome(s). With new observations of
predictor variables we can use the posterior predictive distribution to generate
predicted outcomes.
}
\examples{
\dontrun{
dataMG = load_covid("Brazil","MG")
estimMG = pandemic_model(dataMG)
predMG = posterior_predict(estimMG)
predMG}
}
\references{
CovidLP Team, 2020. CovidLP: Short and Long-term Prediction for COVID-19. Departamento de Estatistica. UFMG,
Brazil. URL: \url{http://est.ufmg.br/covidlp/home/en/}
}
\seealso{
\code{\link{pandemic_model}}, \code{\link{pandemic_stats}} and \code{\link{plot.pandemicPredicted}}. Details
about the models behind the calculations can be seen in \code{\link{models}}.
}
