% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.pandemicPredicted.R
\name{plot.pandemicPredicted}
\alias{plot.pandemicPredicted}
\title{Plot pandemic predictions}
\usage{
\method{plot}{pandemicPredicted}(x, y, term = "long", color = TRUE, summary = TRUE, ...)
}
\arguments{
\item{x}{Output of function \code{\link{posterior_predict.pandemicEstimated}}.}

\item{y}{This parameter does nothing}

\item{term}{A string which indicates whether long term, short term or both plots should be generated.
The argument must be a string being either 'long', 'short' or 'both'.}

\item{color}{A logical variable indicating whether the plot should be colorful or in gray scales.
If TRUE then the plot is colorful otherwise the plot will be gray.}

\item{summary}{A logical variable indicating whether the plot should contains the summary statistics about the pandemic or not.
If TRUE then the plot shows the statistics otherwise no.}

\item{...}{Currently unused.}
}
\value{
A list containing two objects, short and long. "long" shows the long-term predictions
and "short" the short-term predictions. If any of them did not get plotted due to lack of prediction or due to the \code{term}
argument, its value will return NULL.

By default only the long-term plot is generated, which means that the short term plot returns NULL.
This is changed with the \code{term} argument.
\item{\code{long}}{
  The plotted long-term prediction. The predictions are made on daily new confirmed cases or daily new deaths.
  }
  \item{\code{short}}{
  The plotted short-term prediction. The predictions are made on daily cumulative cases or daily cumulative deaths.
  }
}
\description{
S3 method that plots the predicted data into an interactive graphic.
}
\examples{
\dontrun{
dataMG = load_covid("Brazil","MG")
estimMG = pandemic_model(dataMG)
predMG = posterior_predict(estimMG)
statsMG = pandemic_stats(predMG)
plot(predMG)}
}
\references{
CovidLP Team, 2020. CovidLP: Short and Long-term Prediction for COVID-19. Departamento de Estatistica. UFMG,
Brazil. URL: \url{http://est.ufmg.br/covidlp/home/en/}
}
\seealso{
\code{\link{posterior_predict.pandemicEstimated}}, \code{\link{pandemic_stats}} and \code{\link{plottedPandemic-objects}}.
}
