% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadLatest.R
\name{loadLatest}
\alias{loadLatest}
\title{Load Recent PM2.5 Monitoring Data}
\usage{
loadLatest()
}
\value{
A \emph{ws_monitor} object with PM2.5 monitoring data.
}
\description{
Wrapper function to load and combine the most recent 
data from AirNow, AIRSIS and WRCC:

\preformatted{
airnow <- airnow_loadLatest()
airsis <- airsis_loadLatest()
wrcc <- wrcc_loadLatest()
ws_monitor <- monitor_combine(list(airnow, airsis, wrcc))
}

Avaialble RData and associated log files can be seen at:
\href{https://haze.airfire.org/monitoring/latest/RData/}{https://haze.airfire.org/monitoring/latest/RData/}
}
\examples{
\dontrun{
ca <- loadLatest() \%>\% monitor_subset(stateCodes='CA')
}
}
\seealso{
\code{\link{airsis_loadDaily}}
}
\keyword{AIRSIS}
\keyword{AirNow}
\keyword{WRCC}
