% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airnow_downloadSites.R
\name{airnow_downloadSites}
\alias{airnow_downloadSites}
\title{Download AirNow Site Location Metadata}
\usage{
airnow_downloadSites(baseUrl = "https://files.airnowtech.org/airnow/today/",
  file = "monitoring_site_locations.dat")
}
\arguments{
\item{baseUrl}{location of the AirNow monitoring site locations file}

\item{file}{name of the AirNow monitoring site locations file}
}
\value{
Dataframe of site location metadata.
}
\description{
The \url{https://airnowtech.org} site provides both air pollution
monitoring data as well as monitoring site location metadata. This 
function retrieves the most recent version of the site location metadata file and returns it as a dataframe.

A description of the data format is publicly available at the
\href{https://www.airnowapi.org/docs/MonitoringSiteFactSheet.pdf}{Monitoring Site Fact Sheet}.
}
\note{
As of December, 2016, the \code{monitoring_site_locations.dat} file has an encoding of 
"CP437" (aka "Non-ISO extended-ASCII" or "IBMPC 437") and will be converted to "UTF-8"
so that French and Spanish language place names are properly encoded in the returned dataframe.
}
\examples{
\dontrun{
sites <- airnow_downloadSites()
}
}
\seealso{
\link{airnow_createMetaDataframes}
}
\keyword{AirNow}

