% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MzTabReader.R
\docType{class}
\name{MzTabReader-class}
\alias{MzTabReader-class}
\alias{MzTabReader}
\title{Class to read an mzTab file and store the tables internally.}
\description{
The 'sections' field is initialized after $readMzTab was called.
The 'fn_map' fields should be initialized via ...$fn_map$readMappingFile(...) manually if user-defined filename mappings are desired
and is automatically updated/queried when $readMzTab is called.
}
\section{Fields}{

\describe{
\item{\code{sections}}{MzTab sections as list. Valid list entries are: "MTD", "PRT", "PEP", "PSM", "SML", "filename" and "comments"}

\item{\code{fn_map}}{FilenameMapper which can translate raw filenames into something shorter}
}}

\section{Methods}{

\describe{
\item{\code{getEvidence()}}{Basically the PSM table and additionally columns named 'raw.file' and 'fc.raw.file'.}

\item{\code{getMSMSScans(identified_only = FALSE)}}{Basically the PSM table (partially renamed columns) and additionally two columns 'raw.file' and 'fc.raw.file'. 
If identified_only is TRUE, only MS2 scans which were identified (i.e. a PSM) are returned -- this is equivalent to msms.txt in MaxQuant.}

\item{\code{getParameters()}}{Converts internal mzTab metadata section to a two column key-value data.frame similar to MaxQuants parameters.txt.}

\item{\code{getProteins()}}{Basically the PRT table ...}

\item{\code{getSummary()}}{Converts internal mzTab metadata section to a two data.frame with columns 'fc.raw.file', 'ms.ms.identified....'
similar to MaxQuants summary.txt.}

\item{\code{renameColumns(dt, namelist)}}{Renames all columns and throws a warning if a column does not exist in the data}

\item{\code{RTUnitCorrection(dt)}}{Convert all RT columns from seconds (OpenMS default) to minutes (MaxQuant default)}
}}

