% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data_Cox.R
\docType{data}
\name{sim_data_Cox}
\alias{sim_data_Cox}
\title{Simulated Dataset for Survival Outcome (Cox Model)}
\format{
## `sim_data_Cox`
A data frame with 1,000 rows and 7 columns:
\describe{
  \item{S}{Principal Strata: "never taker", "complier" or "always taker"}
  \item{Z}{Randomized treatment arm: 0 = control, 1 = treatment}
  \item{D}{Actual treatment arm: 0 = control, 1 = treatment}
  \item{T}{True outcome: event time}
  \item{C}{Censor time}
  \item{delta}{Event indicator. 1 means true outcome is observed; 0 means otherwise}
  \item{Y}{The observed event time or censor time}
}
}
\usage{
sim_data_Cox
}
\description{
A dataset generated for illustration of the principal stratification analysis.
This dataset represents the common case of non-compliance.
}
\details{
The dataset represents the scenario where actual treatment might not be in compliance
with the randomized (assigned) treatment. Defiers and always-takers are ruled out, leaving two
strata, "never-taker" and "complier" randomly sampled with 
probability 0.3, 0.7 respectively. The assigned treatment \eqn{Z} is randomized
with 0.5 probability for either arm. The true event time \eqn{T} is given by the following 
Weibull-Cox distribution
\describe{
\item{never-taker}{\eqn{Y \sim Weibull-Cox(theta = 1, mu = 0.3)}}
\item{complier}{\eqn{Y \sim Weibull-Cox(theta = 1, mu = 2 - 0.6*Z)}}
} and the censor time \eqn{C} is uniformly drawn between 0.5 and 2.

The exclusion restriction assumption holds for never-takers in this
generated dataset.
}
\keyword{datasets}
