% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print.PSTR}
\alias{print.PSTR}
\title{Print the object of the class PSTR.}
\usage{
\method{print}{PSTR}(x, mode = "summary", digits = 4, ...)
}
\arguments{
\item{x}{an object of the class PSTR returned from some functions in the package. See below "See Also" for a list of these functions.}

\item{mode}{a vector of character strings specifying which results to print. It takes the values c('summary', 'tests', 'estimates', 'evaluation'). By default 'summary'.}

\item{digits}{integer indicating the number of decimal places (for the \code{round} function inside) to be used. Negative values are allowed (see \code{round}).}

\item{...}{further arguments passed to or from other methods. Ignored here.}
}
\description{
This function prints the object of the class PSTR.
}
\examples{
pstr = NewPSTR(Hansen99, dep='inva', indep=4:20, indep_k=c('vala','debta','cfa','sales'),
    tvars=c('vala','debta','cfa','sales'), iT=14)
print(pstr)
print(pstr, mode='summary',digits=2)
}
\seealso{
Functions which return an object of the class PSTR:

\code{\link{NewPSTR}}, \code{\link{LinTest}}, \code{\link{WCB_LinTest}}, \code{\link{EstPSTR}}, \code{\link{EvalTest}}, \code{\link{WCB_TVTest}} and \code{\link{WCB_HETest}}
}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{utils}
