% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSPMecodyn.R
\name{PSPMecodyn}
\alias{PSPMecodyn}
\title{Ecological dynamics of a structured population model computed using the Escalator Boxcar Train}
\usage{
PSPMecodyn(
  modelname = NULL,
  startstate = NULL,
  timepars = NULL,
  bifpars = NULL,
  parameters = NULL,
  options = NULL,
  clean = FALSE,
  force = FALSE,
  debug = FALSE,
  silent = FALSE
)
}
\arguments{
\item{modelname}{(string, required)
\preformatted{}
              Basename of the file with the model specification. The file
              should have an extension ".h". For example, the model "PNAS2002"
              is specified in the file "PNAS2002.h". If the model is specified 
              in R include the .R extension explicitly, i.e. specify the model
              name as "PNAS2002.R"}

\item{startstate}{(list, required)
\preformatted{}
              The initial environmental and population state from which to start the
              simulation of the dynamics. This list should have the identical layout
              as a list returned by the function csbread().
              As a minimum, the list should contain a vector 'Environment' specifying
              the initial values of the environmental variables, and a matrix 'Pop00'
              (assuming there is only a single population in the model), which specifies
              on each row the number and individual state variables of a cohort of
              while the different rows specify all the cohorts in the population.}

\item{timepars}{(row vector of length 4, required)
\preformatted{}
              Vector of length 4 specifying the settings for the time integration:
\preformatted{}
             \verb{timepars[1]}: Cohort cycle time, i.e. time interval between starts of new
             boundary cohorts
\preformatted{}
             \verb{timepars[2]}: Output time interval, i.e. time interval between data output
             to .out file
\preformatted{}
             \verb{timepars[3]}: State output interval, i.e. time interval between complete
             state output to .csb file
\preformatted{}
             \verb{timepars[4]}: Maximum integration time, i.e. maximum time value until which
             to continue the integration}

\item{bifpars}{(row vector of length 6, optional)
\preformatted{}
              Vector of length 6 specifying the settings for the bifurcation settings. If
              not specified a normal time integration is carried out.
\preformatted{}
              \verb{bifpars[1]}: Index of the bifurcation parameter
\preformatted{}
              \verb{bifpars[2]}: Starting value of the bifurcation parameter
\preformatted{}
              \verb{bifpars[3]}: Step size in the bifurcation parameter
\preformatted{}
              \verb{bifpars[4]}: Final value of the bifurcation parameter
\preformatted{}
              \verb{bifpars[5]}: Period of producing data output during each bifurcation interval
\preformatted{}
              \verb{bifpars[6]}: Period of producing state output during each bifurcation interval}

\item{parameters}{(row vector, optional, can be left equal to its default NULL)
\preformatted{}
              Vector of length PARAMETER_NR (set in the model program
              file; This is the length of the variable 'DefaultParameters' if the
              model is specified in R), specifying the values for the model
              parameters to use in the computation. Vectors of other lengths,
              including an empty vector will be ignored.}

\item{options}{(row vector of strings, optional, can be left equal to its default NULL)
\preformatted{}
              Vector with pairs of strings, consisting of an option name and a value (for
              example c("info", "1")).
              Possible option names and their values are:
\preformatted{}
              \verb{"info", "<index>"}:  Level of performance information on the DOPRI5
                      integrator written to .err file (1, 2, 3 or 4)
\preformatted{}
              \verb{"report", "<index>"}:  Interval between reporting of data output to
                      console ( > 0)}

\item{clean}{(Boolean, optional argument)
\preformatted{}
              Specify clean = TRUE as argument to remove all the result files
              of the model before the computation}

\item{force}{(Boolean, optional argument)
\preformatted{}
              Specify force = TRUE as argument to force a rebuilding of the model
              before the computation}

\item{debug}{(Boolean, optional argument)
\preformatted{}
              Specify debug = TRUE as argument to compile the model in verbose
              mode and with debugging flag set}

\item{silent}{(Boolean, optional argument)
\preformatted{}
              Specify silent = TRUE as argument to suppress reporting of compilation
              commands and results on the console}
}
\value{
The output is a list containing the following elements:
\preformatted{}
             \verb{curvepoints}: Matrix with output for all computed points along the curve
\preformatted{}
             \verb{curvedesc}:   Column vector with strings, summarizing the numerical details
             of the computed curve (i.e., initial point, parameter values,
             numerical settings used)
}
\description{
\code{PSPMecodyn} computes the dynamics of a physiologically structured population model
starting from an environmental and population state that is computed with \code{\link{PSPMequi}}.
If starting from an arbitrary state is required, the list specifying the initial state should
have the same layout as produced by \code{\link{PSPMequi}}.
}
\details{
output <- PSPMecodyn(modelname = NULL, startstate = NULL, timepars = NULL, 
                       bifpars = NULL, parameters = NULL, options = NULL,
                       clean = FALSE, force = FALSE, debug = FALSE, silent = FALSE)
}
\examples{
\dontrun{
initstate <- list(Environment = c(1.561e-04, 1.270e-04, 4.008e-06), 
                  Pop00 = matrix(c(0.001, 0, 7.0, 1.0E-5, 300, 111),
                  ncol = 3, byrow = TRUE))
PSPMecodyn("PNAS2002", initstate, c(1, 1, 10, 100))
}

}
