\name{bal.cs.psa}
\alias{bal.cs.psa}
\title{Balance for Categorical Covariate: Random Strata as part of a PSA}
\description{Function provides a measure of the balance achieved between control and treatment 
groups for a categorical covariate from user defined strata. This statistic is compared to the same measure 
for randomly permuted strata.  
}
\usage{
bal.cs.psa(categorical, treatment = NULL, strata = NULL, B = 1000, 
    eps =.02, main = NULL, ...)
}
\arguments{
  \item{categorical}{Categorical covariate that is being balanced within strata 
  in a PSA. If 
  \code{categorical} has three columns, then the second and third
  are assumed to be the treatment and strata respectively.  Missing values are
  not allowed. May be factor or numeric. }
 \item{treatment}{Binary variable of same length as \code{categorical}; generally 0 for 'control,' 1 for 'treatment.' }
 \item{strata}{Integer variable;  a vector of same length as \code{categorical} indicating the 
  derived strata from estimated propensity scores.}
  \item{B}{Numeric; number of randomly generated iterations of the balance 
  measure are created for the comparison distribution.}
  \item{eps}{Numeric; ensures that weighting is reasonable for small categories.}
  \item{main}{Title passed to \code{histogram}.}
  \item{\dots}{Other graphical parameters passed to \code{histogram}.}
}
\details{This function measures the balance achieved across K strata for a categorical covariate with J categories.  
If \eqn{p_{ijk}} is the proportion of cases in stratum k, category j, and treatment i,   
then the statistic is the sum over all K, J of \eqn{ |\sqrt{p_{0jk} + \epsilon} - \sqrt{p_{1jk} + \epsilon } | }.  A permutation distribution 
is generated by randomly assigning cases to strata, thus generating B permuted stratifications and the associated B permutation statistics. 
The permutation stratifications are generated under a fixed marginals model to retain comparability with the original stratification. 
A histogram of the permutation statistics is produced with the original statistic referenced as a red dot. 

}
\value{In addition to the histogram, a list with the following components is returned:
  \item{balance.orig }{Balance measure of user defined strata.}
  \item{rank.orig}{Rank of original balance measure in comparison 
  with the B randomly generated values.}
  }
\author{James E. Helmreich \email{ James.Helmreich@Marist.edu}

 Robert M. Pruzek \email{RMPruzek@yahoo.com}}
\seealso{ \code{bal.cws.psa}, \code{bal.ms.psa}, \code{bal.ks.psa} }
\examples{#Everything random
categorical<-sample(4,1000,replace=TRUE)
treatment<-sample(c(0,1),1000,replace=TRUE)
strata<-sample(5,1000,replace=TRUE)
bal.cs.psa(categorical,treatment,strata)

#Perfect balance on 80%, random on last 20%
categorical<-rep(sample(5,1000,replace=TRUE),2)
treatment<-c(rep(0,1000),rep(1,1000))
strat<-sample(6,1200,replace=TRUE)
strat<-c(strat[1:1000],strat[1:800],strat[1001:1200])
bal.cs.psa(categorical,treatment,strat,B=200)

}
\keyword{ htest }
