% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramsPOUMM.R
\name{rTrajectoryOU}
\alias{rTrajectoryOU}
\title{Generation of a random trajectory of an OU process starting from a given
initial state}
\usage{
rTrajectoryOU(z0, t, alpha, theta, sigma, steps = 1)
}
\arguments{
\item{z0}{Numeric value, initial state.}

\item{t}{Numeric value or vector of size steps, denoting the time-step(s).}

\item{alpha, theta, sigma}{Numeric values, parameters of the OU process.}

\item{steps}{Integer, number of steps.}
}
\value{
A numeric vector of length steps containing the generated values
  at times 0+t, 0+2t, ..., 0+steps*t.
}
\description{
Generates a trajectory xt given initial state z0 according to an
  Ornstein-Uhlenbeck process.
}
\examples{
z0 <- 0
nSteps <- 100
t <- 0.01
trajectory <- rTrajectoryOU(z0, t, 2, 2, 1, steps = nSteps)
plot(trajectory, type = 'l')

}
