% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPOUMM.R
\name{mcmcPOUMMGivenPriorTreeVTips}
\alias{mcmc.poumm}
\alias{mcmcPOUMMGivenPriorTreeVTips}
\title{MCMC-sampling from a posterior distribution of a P(OU)MM model given tree, 
values at the tips and a prior distribution}
\usage{
mcmcPOUMMGivenPriorTreeVTips(loglik, fitML = NULL, parMapping, parInitMCMC,
  parPriorMCMC, parScaleMCMC, nSamplesMCMC, nAdaptMCMC, thinMCMC, accRateMCMC,
  gammaMCMC, nChainsMCMC, samplePriorMCMC, pruneInfo, ..., verbose = FALSE,
  parallelMCMC = FALSE)
}
\arguments{
\item{loglik}{a log-likelihood function.}

\item{fitML}{an object returned by the maxLikPOUMMGivenTreeVTips}

\item{parMapping}{a function(numeric-vector) transforming a sampled vector on
the scale of the parameters alpha, theta, sigma, sigmae and g0.}

\item{parInitMCMC}{a function(chainNumber) returning the starting point of 
the MCMC as a vector.}

\item{parPriorMCMC}{a function(numeric-vector) returning the log-prior of the
supplied vector}

\item{parScaleMCMC}{numeric matrix indicating the initial jump-distribution 
matrix}

\item{nSamplesMCMC}{integer indicating how many iterations should the 
mcmc-chain contain}

\item{nAdaptMCMC}{integer indicating how many initial iterations should be 
used for adaptation of the jump-distribution matrix}

\item{thinMCMC}{integer indicating the thinning interval of the mcmc-chain}

\item{accRateMCMC}{(MCMC) numeric between 0 and 1 indicating the target 
acceptance rate Passed on to adaptMCMC::MCMC.}

\item{gammaMCMC}{(MCMC) controls the speed of adaption. Should be between 0.5
and 1. A lower gammaMCMC leads to faster adaption. Passed on to 
adaptMCMC::MCMC.}

\item{nChainsMCMC}{integer indicating the number of chains to run. Defaults 
to 1.}

\item{samplePriorMCMC}{logical indicating if only the prior distribution 
should be sampled. This can be useful to compare with mcmc-runs for an 
overlap between prior and posterior distributions.}

\item{pruneInfo}{a list-object returned from the pruneTree(tree, z) function.}

\item{...}{Additional arguments. Currently not used except for the following:
If ... includes debug = TRUE, some debug messages will be written also
outside of the call to loglik.}

\item{verbose}{Logical indicating if some informal messages should be written
during run. This parameter is passed to loglik.}

\item{parallelMCMC}{Logical indicating if chains should be run in parallel.}
}
\value{
a list of coda objects
}
\description{
MCMC-sampling from a posterior distribution of a P(OU)MM model given tree, 
values at the tips and a prior distribution
}
\details{
Currently, this function calls the MCMC function from the adaptMCMC 
  package.
}

