% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_MADE.R
\name{power_MADE}
\alias{power_MADE}
\title{Power Approximation for Overall Average Effects in  Meta-Analysis With Dependent Effect Sizes}
\usage{
power_MADE(
  J,
  mu,
  tau,
  omega,
  rho,
  alpha = 0.05,
  d = 0,
  model = "CHE",
  var_df = "RVE",
  sigma2_dist = NULL,
  n_ES_dist = NULL,
  iterations = 100,
  seed = NULL,
  warning = TRUE,
  average_power = TRUE
)
}
\arguments{
\item{J}{Number of studies. Can be one value or a vector of multiple values.}

\item{mu}{Effect size of practical concern. Can be one value or a vector of multiple values.}

\item{tau}{Between-study SD. Can be one value or a vector of multiple values.}

\item{omega}{Within-study SD. Can be one value or a vector of multiple
values.}

\item{rho}{Correlation coefficient between effect size estimates from the
same study. Can be one value or a vector of multiple values.}

\item{alpha}{Level of statistical significance. Can be one value or a vector
of multiple values. Default is 0.05.}

\item{d}{Contrast value. Can be one value or a vector of multiple values. Default is 0.}

\item{model}{Assumed working model for dependent effect sizes, either
\code{"CHE"} for the correlated-and-hierarchical effects model, \code{"CE"}
for the correlated effects model, or \code{"MLMA"} for the multi-level
meta-analysis model. Default is \code{"CHE"}. Can be one value or a vector
of multiple values.}

\item{var_df}{Indicates the technique used to obtain the sampling variance
of the average effect size estimate and the degrees of freedom, either
\code{"Model"} for model-based variance estimator with degrees of freedom
of \code{J - 1}, \code{"Satt"} for model-based variance estimator with
Satterthwaite degrees of freedom, or \code{"RVE"} for robust variance
estimator with Satterthwaite degrees of freedom. Default is \code{"RVE"}.
Can be one value or a vector of multiple values.}

\item{sigma2_dist}{Distribution of sampling variance estimates from each
study. Can be either a single value, a vector of plausible values, or a
function that generates random values.}

\item{n_ES_dist}{Distribution of the number of effect sizes per study. Can be
either a single value, a vector of plausible values, or a function that
generates random values.}

\item{iterations}{Number of iterations per condition (default is 100).}

\item{seed}{Numerical value for a seed to ensure reproducibility of the
iterated power approximations.}

\item{warning}{Logical indicating whether to return a warning when either
sigma2_dist or n_ES_dist is based on balanced assumptions.}

\item{average_power}{Logical indicating whether to calculate average power
across the iterations for each condition.}
}
\value{
Returns a \code{tibble} with information about the expectation of the
number of studies, the effect size of practical concern, the between-study
and within-study variance components, the sample correlation, the contrast
effect, the level of statistical significance, the sampling variance of
overall average effect size of practical concern, the degrees of freedom,
the power, the mcse, the number of iterations, the model to handle
dependent effect sizes, and the methods used to obtain sampling variance
estimates as well as the number effect sizes per study.
}
\description{
Compute power of the test of the overall average effect size in
a meta-analysis of dependent effect size estimates, given a specified
number of studies, effect size of practical concern, estimation method, and
further assumptions about the distribution of studies.
}
\details{
Find all background material behind the power approximations in
Vembye, Pustejovsky, & Pigott (2022), including arguments for why it is suggested
neither to conduct power analysis based on balanced assumptions about
the number of effects per study and the study variance nor to use the original
power approximation assuming independence among effect sizes (Hedges & Pigott, 2001).
}
\examples{
power <- power_MADE(
   J = c(40, 60),
   mu = 0.2,
   tau = 0.2,
   omega = 0.1,
   rho = 0.7,
   sigma2_dist = \(x) rgamma(x, shape = 5, rate = 10),
   n_ES_dist = \(x) 1 + stats::rpois(x, 5.5 - 1),
   model = c("CHE", "MLMA", "CE"),
   var_df = c("Model", "Satt", "RVE"),
   alpha = .05,
   seed = 10052510,
   iterations =5
 )

power




}
\references{
Vembye, M. H., Pustejovsky, J. E., & Pigott, T. D. (2022).
Power approximations for overall average effects in meta-analysis with dependent effect sizes.
\emph{Journal of Educational and Behavioral Statistics}, 1–33. \doi{10.3102/10769986221127379}

Hedges, L. V., & Pigott, T. D. (2001). The power of statistical tests in meta-analysis.
\emph{Psychological Methods}, 6(3), 203–217. \doi{10.1037/1082-989X.6.3.203}
}
