% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\name{pof_example}
\alias{pof_example}
\title{Get the path of the POF example files}
\usage{
pof_example(path = NULL)
}
\arguments{
\item{path}{Name of file. If \code{NULL}, the POF example files names will be listed.}
}
\value{
A vector with names of all the available POF example files or the path for specific requested POF example file.
}
\description{
This function provides the path of the microdata from year 2017-2018 of the POF example files, loaded with this package.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/trabalho/9050-pesquisa-de-orcamentos-familiares.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
\donttest{
pof_example()
pof_example(path="exampledata.txt")
pof_example(path="input_example.txt")
pof_example(path="dictionaryexample.xls")
pof_example(path="deflatorexample.xls")}
}
\seealso{
\link[POFIBGE]{get_pof} for downloading, labelling, deflating and creating survey design object for POF microdata.\cr \link[POFIBGE]{read_pof} for reading POF microdata.\cr \link[POFIBGE]{pof_labeller} for labelling categorical variables from POF microdata.\cr \link[POFIBGE]{pof_deflator} for adding deflator variable to POF microdata.\cr \link[POFIBGE]{pof_design} for creating POF survey design object.
}
