% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLdist.R
\name{PL}
\alias{PL}
\alias{dPL}
\alias{pPL}
\alias{qPL}
\alias{rPL}
\title{Power Logit Distributions}
\usage{
dPL(x, mu, sigma, lambda, zeta = 2, family, log = FALSE)

pPL(q, mu, sigma, lambda, zeta = 2, family, lower.tail = TRUE, log.p = FALSE)

qPL(p, mu, sigma, lambda, zeta = 2, family, lower.tail = TRUE, log.p = FALSE)

rPL(n, mu, sigma, lambda, zeta = 2, family)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{vector of medians.}

\item{sigma}{vector of dispersion parameters.}

\item{lambda}{vector of skewness parameters.}

\item{zeta}{vector of extra parameters.}

\item{family}{string that specifies the family used to define the power logit distribution. The family is
\code{NO}, \code{TF}, \code{LO}, \code{PE}, \code{SHN}, \code{Hyp} and \code{SLASH} for normal,
Student-t, type II logistic, power exponential, sinh-normal, hyperbolic and slash
distribution, respectively.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p). Default is FALSE.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P(X \le x)} otherwise, \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dPL} gives the density, \code{pPL} gives the distribution function, \code{qPL} gives the quantile function,
and \code{rPL} generates random variables.
}
\description{
Density, distribution function, quantile function and random generation
for power logit distributions.
}
\details{
If \code{zeta} is not specified, it assumes the default value 2. \cr
The power logit distribution has density \deqn{f(y; \mu, \sigma, \lambda) = \lambda r(z^2)/(\sigma y (1-y^\lambda)),}
for \eqn{y \in (0,1)}, in which \eqn{z = [logit(y^\lambda) - logit(\mu^\lambda)]/\sigma}, \eqn{r(\cdot)} is the density generator
and \eqn{\mu \in (0,1)}, \eqn{\sigma>0} and \eqn{\lambda>0} are the median, dispersion and skewness of the distribution. \cr
It is possible to consider \eqn{\lambda=0} to obtain the limiting case, the log-log distribution. This distribution has
density \deqn{f(y; \mu, \sigma, \lambda) = r(z^2)/(\sigma y (-log(y))),} for \eqn{y \in (0,1)},
in which \eqn{z = [-log(-log(y)) - (-log(-log(y)))]/\sigma}. \cr
The \code{family} argument defines the density generator \eqn{r(\cdot)}, which may depend on an extra parameter (\code{zeta}).
}
\examples{
dPL(0.2, mu = 0.3, sigma = 1, lambda=1, zeta = 2, family = "PE")
mu = 0.3; sigma = 1; lambda = 2
set.seed(1)
PLsample = rPL(1000, mu, sigma, lambda, family = "SN",  zeta = 2.5)
hist(PLsample, prob = TRUE, breaks = 15, main = "", las = 1)
curve(dPL(x, mu, sigma, lambda, family = "SN",  zeta = 2.5),
      from = 0.01, to = 0.8, add = TRUE, col = "red")
rug(PLsample)

x = seq(0.01, 0.9,0.01)
y = dPL(x, mu, sigma, lambda, family = "Hyp",  zeta = 2)
plot(x, y, type = "l", lwd = 2, las = 1)

x1 = seq(0.01, 0.4, 0.01)
y1 = dPL(x1, mu, sigma, lambda, family = "Hyp",  zeta = 2)
polygon(c(x1, 0.4, 0), c(y1, 0, 0), col = "lightblue")
text(mu-0.025, 1, paste("P(Y<0.4) = ",
                        round(pPL(0.4, mu, sigma, lambda,
                        family = "Hyp",
                        zeta = 2),2)),
     font = 1, cex = 0.8)

plot(x, pPL(x, mu, sigma, lambda, family = "PE",  zeta = 1.3),
     type = "l", las = 1, lwd = 2,
     ylab = expression(P(Y<y)),
     xlab = "y")
p = pPL(0.5, mu, sigma, lambda, family = "PE",  zeta = 1.3)
q = qPL(p, mu, sigma, lambda, family = "PE",  zeta = 1.3)
points(q, p, pch = 16, col = 2, cex = 1.5)
text(0.55, 0.83, paste("(", 0.5, ",", round(p, 2), ")"), font = 2,
     cex = 0.8, col = "red")
}
\references{
Queiroz, F. F. and Ferrari, S. L. P. (2022). Power logit regression
for modeling bounded data. \emph{arXiv preprint arXiv}:2202.01697.
}
