% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNnetworkfamily-class.R
\name{ZIPLNnetworkfamily}
\alias{ZIPLNnetworkfamily}
\title{An R6 Class to represent a collection of ZIPLNnetwork}
\description{
The function \code{\link[=ZIPLNnetwork]{ZIPLNnetwork()}} produces an instance of this class.

This class comes with a set of methods, some of them being useful for the user:
See the documentation for \code{\link[=getBestModel]{getBestModel()}},
\code{\link[=getModel]{getModel()}} and \link[=plot.ZIPLNnetworkfamily]{plot()}
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
fits <- PLNnetwork(Abundance ~ 1, data = trichoptera)
class(fits)
}
\seealso{
The function \code{\link[=ZIPLNnetwork]{ZIPLNnetwork()}}, the class \code{\link{ZIPLNfit_sparse}}
}
\section{Super classes}{
\code{\link[PLNmodels:PLNfamily]{PLNmodels::PLNfamily}} -> \code{\link[PLNmodels:Networkfamily]{PLNmodels::Networkfamily}} -> \code{ZIPLNnetworkfamily}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{covariates0}}{the matrix of covariates included in the ZI component}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ZIPLNnetworkfamily-new}{\code{ZIPLNnetworkfamily$new()}}
\item \href{#method-ZIPLNnetworkfamily-stability_selection}{\code{ZIPLNnetworkfamily$stability_selection()}}
\item \href{#method-ZIPLNnetworkfamily-clone}{\code{ZIPLNnetworkfamily$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="getModel"><a href='../../PLNmodels/html/PLNfamily.html#method-PLNfamily-getModel'><code>PLNmodels::PLNfamily$getModel()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="postTreatment"><a href='../../PLNmodels/html/PLNfamily.html#method-PLNfamily-postTreatment'><code>PLNmodels::PLNfamily$postTreatment()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="print"><a href='../../PLNmodels/html/PLNfamily.html#method-PLNfamily-print'><code>PLNmodels::PLNfamily$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="Networkfamily" data-id="coefficient_path"><a href='../../PLNmodels/html/Networkfamily.html#method-Networkfamily-coefficient_path'><code>PLNmodels::Networkfamily$coefficient_path()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="Networkfamily" data-id="getBestModel"><a href='../../PLNmodels/html/Networkfamily.html#method-Networkfamily-getBestModel'><code>PLNmodels::Networkfamily$getBestModel()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="Networkfamily" data-id="optimize"><a href='../../PLNmodels/html/Networkfamily.html#method-Networkfamily-optimize'><code>PLNmodels::Networkfamily$optimize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="Networkfamily" data-id="plot"><a href='../../PLNmodels/html/Networkfamily.html#method-Networkfamily-plot'><code>PLNmodels::Networkfamily$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="Networkfamily" data-id="plot_objective"><a href='../../PLNmodels/html/Networkfamily.html#method-Networkfamily-plot_objective'><code>PLNmodels::Networkfamily$plot_objective()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="Networkfamily" data-id="plot_stars"><a href='../../PLNmodels/html/Networkfamily.html#method-Networkfamily-plot_stars'><code>PLNmodels::Networkfamily$plot_stars()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="Networkfamily" data-id="show"><a href='../../PLNmodels/html/Networkfamily.html#method-Networkfamily-show'><code>PLNmodels::Networkfamily$show()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNnetworkfamily-new"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNnetworkfamily-new}{}}}
\subsection{Method \code{new()}}{
Initialize all models in the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNnetworkfamily$new(penalties, data, control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{penalties}}{a vector of positive real number controlling the level of sparsity of the underlying network.}

\item{\code{data}}{a named list used internally to carry the data matrices}

\item{\code{control}}{a list for controlling the optimization.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Update current \code{\link{PLNnetworkfit}} with smart starting values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNnetworkfamily-stability_selection"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNnetworkfamily-stability_selection}{}}}
\subsection{Method \code{stability_selection()}}{
Compute the stability path by stability selection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNnetworkfamily$stability_selection(
  subsamples = NULL,
  control = ZIPLNnetwork_param()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subsamples}}{a list of vectors describing the subsamples. The number of vectors (or list length) determines the number of subsamples used in the stability selection. Automatically set to 20 subsamples with size \code{10*sqrt(n)} if \code{n >= 144} and \code{0.8*n} otherwise following Liu et al. (2010) recommendations.}

\item{\code{control}}{a list controlling the main optimization process in each call to \code{\link[=PLNnetwork]{PLNnetwork()}}. See \code{\link[=ZIPLNnetwork]{ZIPLNnetwork()}} and \code{\link[=ZIPLN_param]{ZIPLN_param()}} for details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNnetworkfamily-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNnetworkfamily-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNnetworkfamily$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
