% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNfit-class.R
\name{PLNfit_fixedcov}
\alias{PLNfit_fixedcov}
\title{An R6 Class to represent a PLNfit in a standard, general framework, with fixed (inverse) residual covariance}
\description{
An R6 Class to represent a PLNfit in a standard, general framework, with fixed (inverse) residual covariance

An R6 Class to represent a PLNfit in a standard, general framework, with fixed (inverse) residual covariance
}
\examples{
\dontrun{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLN(Abundance ~ 1, data = trichoptera)
class(myPLN)
print(myPLN)
}
}
\section{Super class}{
\code{\link[PLNmodels:PLNfit]{PLNmodels::PLNfit}} -> \code{PLNfit_fixedcov}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{nb_param}}{number of parameters in the current PLN model}

\item{\code{vcov_model}}{character: the model used for the residual covariance}

\item{\code{vcov_coef}}{matrix of sandwich estimator of the variance-covariance of B (needs known covariance at the moment)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PLNfit_fixedcov-new}{\code{PLNfit_fixedcov$new()}}
\item \href{#method-PLNfit_fixedcov-optimize}{\code{PLNfit_fixedcov$optimize()}}
\item \href{#method-PLNfit_fixedcov-postTreatment}{\code{PLNfit_fixedcov$postTreatment()}}
\item \href{#method-PLNfit_fixedcov-clone}{\code{PLNfit_fixedcov$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="optimize_vestep"><a href='../../PLNmodels/html/PLNfit.html#method-PLNfit-optimize_vestep'><code>PLNmodels::PLNfit$optimize_vestep()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="predict"><a href='../../PLNmodels/html/PLNfit.html#method-PLNfit-predict'><code>PLNmodels::PLNfit$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="predict_cond"><a href='../../PLNmodels/html/PLNfit.html#method-PLNfit-predict_cond'><code>PLNmodels::PLNfit$predict_cond()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="print"><a href='../../PLNmodels/html/PLNfit.html#method-PLNfit-print'><code>PLNmodels::PLNfit$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="show"><a href='../../PLNmodels/html/PLNfit.html#method-PLNfit-show'><code>PLNmodels::PLNfit$show()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="update"><a href='../../PLNmodels/html/PLNfit.html#method-PLNfit-update'><code>PLNmodels::PLNfit$update()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit_fixedcov-new"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit_fixedcov-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{\link{PLNfit}} model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit_fixedcov$new(responses, covariates, offsets, weights, formula, control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{responses}}{the matrix of responses (called Y in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{covariates}}{design matrix (called X in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{offsets}}{offset matrix (called O in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{weights}}{an optional vector of observation weights to be used in the fitting process.}

\item{\code{formula}}{model formula used for fitting, extracted from the formula in the upper-level call}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit_fixedcov-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit_fixedcov-optimize}{}}}
\subsection{Method \code{optimize()}}{
Call to the NLopt or TORCH optimizer and update of the relevant fields
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit_fixedcov$optimize(responses, covariates, offsets, weights, config)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{responses}}{the matrix of responses (called Y in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{covariates}}{design matrix (called X in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{offsets}}{offset matrix (called O in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{weights}}{an optional vector of observation weights to be used in the fitting process.}

\item{\code{config}}{part of the \code{control} argument which configures the optimizer}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit_fixedcov-postTreatment"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit_fixedcov-postTreatment}{}}}
\subsection{Method \code{postTreatment()}}{
Update R2, fisher and std_err fields after optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit_fixedcov$postTreatment(
  responses,
  covariates,
  offsets,
  weights = rep(1, nrow(responses)),
  config_post,
  config_optim,
  nullModel = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{responses}}{the matrix of responses (called Y in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{covariates}}{design matrix (called X in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{offsets}}{offset matrix (called O in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{weights}}{an optional vector of observation weights to be used in the fitting process.}

\item{\code{config_post}}{a list for controlling the post-treatments (optional bootstrap, jackknife, R2, etc.). See details}

\item{\code{config_optim}}{a list for controlling the optimization parameter. See details}

\item{\code{nullModel}}{null model used for approximate R2 computations. Defaults to a GLM model with same design matrix but not latent variable.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The list of parameters \code{config} controls the post-treatment processing, with the following entries:
\itemize{
\item trace integer for verbosity. should be > 1 to see output in post-treatments
\item jackknife boolean indicating whether jackknife should be performed to evaluate bias and variance of the model parameters. Default is FALSE.
\item bootstrap integer indicating the number of bootstrap resamples generated to evaluate the variance of the model parameters. Default is 0 (inactivated).
\item variational_var boolean indicating whether variational Fisher information matrix should be computed to estimate the variance of the model parameters (highly underestimated). Default is FALSE.
\item rsquared boolean indicating whether approximation of R2 based on deviance should be computed. Default is TRUE
}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit_fixedcov-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit_fixedcov-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit_fixedcov$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
