% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{gsPLMIX_to_mcmc}
\alias{gsPLMIX_to_mcmc}
\title{MCMC class objects from the Gibbs sampling simulations of a Bayesian mixture of Plackett-Luce models}
\usage{
gsPLMIX_to_mcmc(gsPLMIX_out)
}
\arguments{
\item{gsPLMIX_out}{Object of class \code{gsPLMIX} returned by the \code{gibbsPLMIX} function.}
}
\value{
An \code{mcmc} class object.
}
\description{
Coerce the Gibbs sampling simulations for a Bayesian mixture of Plackett-Luce models into an \code{mcmc} class object.
}
\details{
\code{gsPLMIX_to_mcmc} attemps to coerce its argument by recalling the \code{as.mcmc} function of the \code{coda} package.
}
\examples{

data(d_carconf)
GIBBS <- gibbsPLMIX(pi_inv=d_carconf, K=ncol(d_carconf), G=3, n_iter=30, n_burn=10)

## Coerce the posterior samples into an mcmc class object
gsPLMIX_to_mcmc(GIBBS)

}
\references{
Plummer, M., Best, N., Cowles, K. and Vines, K. (2006). CODA: Convergence Diagnosis and Output Analysis for MCMC, \emph{R News}, \bold{6}, pages 7--11, ISSN: 1609-3631.
}
\seealso{
\code{\link[coda]{as.mcmc}}
}
\author{
Cristina Mollica and Luca Tardella
}
