% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal_to_binary.R
\name{ordinal_to_binary_}
\alias{ordinal_to_binary_}
\title{convert a column of categorical covariates into a number of 
columns with a binary flag for each category}
\usage{
ordinal_to_binary_(df, col_name, prefix = NULL, overwrite = FALSE)
}
\arguments{
\item{df}{data frame}

\item{col_name}{column name to split into multiple binary flags}

\item{prefix}{string name if want to specify a prefix to label 
the binary flag columns other than the original col_name}

\item{overwrite}{overwrite any existing columns if the newly generated columns
share the same name}
}
\description{
convert a column of categorical covariates into a number of 
columns with a binary flag for each category
}
\examples{
\donttest{
library(dplyr)
df <- data_frame(OCC = c(1, 1, 2, 3))
df \%>\% ordinal_to_binary_("OCC")
df \%>\% ordinal_to_binary_("OCC", prefix = "OCCASION")

df2 <- data_frame(OCC = c(1, 1, 2, 3), OCC1 = 999)
df2 \%>\% ordinal_to_binary_("OCC")
df2 \%>\% ordinal_to_binary_("OCC", overwrite=T)
}
}
