% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/29_NORMAL_TEST.R
\name{normal.test}
\alias{normal.test}
\title{Multi-period predictive power test}
\usage{
normal.test(pdc, odr, alpha = 0.05)
}
\arguments{
\item{pdc}{Numeric vector of calibrated probabilities of default (PD).}

\item{odr}{Numeric vector of observed default rates.}

\item{alpha}{Significance level of p-value for implemented tests. Default is 0.05.}
}
\value{
The command \code{normal.test} returns a data frame with estimated difference between \code{odr} and
\code{pdc}, test statistics, standard error of the test statistics, selected significance level,
p-value of test statistics and finally the test results.
}
\description{
\code{normal.test} performs multi-period testing of PD model predictive power. This procedure can be applied
on the level of the rating grade as well on the portfolio level.
}
\examples{
set.seed(678)
normal.test(pdc = rep(0.02, 5), 
odr = runif(5, 0.02, 0.03)) 
}
\references{
Basel Committee on Banking Supervision (2005). Studies on the Validation of Internal
Rating Systems, working paper no. 14.
}
