% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/28_HHI.R
\name{hhi}
\alias{hhi}
\title{Herfindahl-Hirschman Index (HHI)}
\usage{
hhi(x)
}
\arguments{
\item{x}{Numeric vector of input values (e.g. number of observations or sum of exposure per rating grade).}
}
\value{
The command \code{hhinormal.test} returns single element numeric vector of HHI value.
}
\description{
\code{hhi} performs calculation on Herfindahl-Hirschman Index.
}
\examples{
#simulate PD model and rating scale
suppressMessages(library(PDtoolkit))
data(loans)
res <- stepFWDr(start.model = Creditability ~ 1, 
   p.value = 0.05, 
   db = loans)
mod.predictions <- unname(predict(res$model, type = "response"))
rating.scale <- sts.bin(y = loans$Creditability, x = mod.predictions)[[1]]
#calculate HHI 
hhi(x = rating.scale$no)
}
