% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/26_CONSTRAINED_LOGIT.R
\name{constrained.logit}
\alias{constrained.logit}
\title{Constrained logistic regression}
\usage{
constrained.logit(db, x, y, lower, upper)
}
\arguments{
\item{db}{Data set of risk factors and target variable.}

\item{x}{Character vector of risk factors (independent variables) used in logistic regression.}

\item{y}{Character vector of target (dependent variable) used in logistic regression.}

\item{lower}{Numeric vector of lower boundaries of the coefficients. This vector should contain value of the intercept,
therefore number of elements should be equal to number of elements of the argument \code{x} plus one.}

\item{upper}{Numeric vector of upper boundaries of the coefficients. This vector should contain value of the intercept,
therefore number of elements should be equal to number of elements of the argument \code{x} plus one.}
}
\value{
The command \code{constrained.logit} returns list of two vectors. The first vector contains values of the
estimated coefficients, while the second vector contains predictions of the constrained logistic regression.
}
\description{
\code{constrained.logit} performs estimation of logistic regression with constrains on values of the
estimated coefficient.
}
\examples{
suppressMessages(library(PDtoolkit))
data(loans)
#model 1
reg.1 <- glm(Creditability ~ `Account Balance`, family = "binomial", data = loans)
summary(reg.1)$coefficient
loans$pred.1 <-  unname(predict(reg.1, type = "response"))
#model 2
reg.2 <- glm(Creditability ~ `Age (years)`, family = "binomial", data = loans)
summary(reg.2)$coefficient
loans$pred.2 <-  unname(predict(reg.2, type = "response"))
#integration
fm <- glm(Creditability ~ pred.1 + pred.2, family = "binomial", data = loans)
summary(fm)$coefficient
fm.pred <- predict(fm, type = "response", newdata = loans)
auc.model(predictions = fm.pred, observed = loans$Creditability)
#constrained integration (regression)
cl.r <- constrained.logit(db = loans, 
		  x = c("pred.1", "pred.2"), 
		  y = "Creditability",
		  lower = c(-Inf, -Inf, -Inf), 
		  upper = c(Inf, 4.5, Inf))
names(cl.r)
cl.r[["beta"]]
auc.model(predictions = cl.r[["prediction"]], observed = loans$Creditability)
}
