% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/19_STEP_FWD.R
\name{stepFWD}
\alias{stepFWD}
\title{Customized stepwise regression with p-value and trend check}
\usage{
stepFWD(
  start.model,
  p.value = 0.05,
  coding = "WoE",
  coding.start.model = TRUE,
  check.start.model = TRUE,
  db,
  offset.vals = NULL
)
}
\arguments{
\item{start.model}{Formula class that represents starting model. It can include some risk factors, but it can be
defined only with intercept (\code{y ~ 1} where \code{y} is target variable).}

\item{p.value}{Significance level of p-value of the estimated coefficients. For \code{WoE} coding this value is
is directly compared to the p-value of the estimated coefficients, while for \code{dummy} coding
multiple Wald test is employed and its p-value is used for comparison with selected threshold (\code{p.value}).}

\item{coding}{Type of risk factor coding within the model. Available options are: \code{"WoE"} (default) and
\code{"dummy"}. If \code{"WoE"} is selected, then modalities of the risk factors are replaced
by WoE values, while for \code{"dummy"} option dummies (0/1) will be created for \code{n-1}
modalities where \code{n} is total number of modalities of analyzed risk factor.}

\item{coding.start.model}{Logical (\code{TRUE} or \code{FALSE}), if the risk factors from the starting model should be WoE coded.
It will have an impact only for WoE coding option. Default is \code{TRUE}.}

\item{check.start.model}{Logical (\code{TRUE} or \code{FALSE}), if risk factors from the starting model should be
checked for p-value and trend in stepwise process. Default is \code{TRUE}.
If \code{FALSE} is selected, then \code{coding.start.model} is forced to \code{TRUE}.}

\item{db}{Modeling data with risk factors and target variable. All risk factors (apart from the risk factors from the starting model)
should be categorized and as of character type.}

\item{offset.vals}{This can be used to specify an a priori known component to be included in the linear predictor during fitting.
This should be \code{NULL} or a numeric vector of length equal to the number of cases. Default is \code{NULL}.}
}
\value{
The command \code{stepFWD} returns a list of four objects.\cr
The first object (\code{model}), is the final model, an object of class inheriting from \code{"glm"}.\cr
The second object (\code{steps}), is the data frame with risk factors selected at each iteration.\cr
The third object (\code{warnings}), is the data frame with warnings if any observed.
The warnings refer to the following checks: if risk factor has more than 10 modalities,
if any of the bins (groups) has less than 5\% of observations and
if there are problems with WoE calculations.\cr
The final, fourth, object \code{dev.db} returns the model development database.
}
\description{
\code{stepFWD} customized stepwise regression with p-value and trend check. Trend check is performed
comparing observed trend between target and analyzed risk factor and trend of the estimated coefficients within the
logistic regression. Note that procedure checks the column names of supplied \code{db} data frame therefore some
renaming (replacement of special characters) is possible to happen. For details check help example.
}
\examples{
suppressMessages(library(PDtoolkit))
data(loans)
#identify numeric risk factors
num.rf <- sapply(loans, is.numeric)
num.rf <- names(num.rf)[!names(num.rf)\%in\%"Creditability" & num.rf]
#discretized numeric risk factors using ndr.bin from monobin package
loans[, num.rf] <- sapply(num.rf, function(x) 
ndr.bin(x = loans[, x], y = loans[, "Creditability"])[[2]])
str(loans)
res <- stepFWD(start.model = Creditability ~ 1, 
	   p.value = 0.05, 
	   coding = "dummy",
	   db = loans)
summary(res$model)$coefficients
rf.check <- tapply(res$dev.db$Creditability, 
		 res$dev.db$Value_Savings_Stocks, 
		 mean)
rf.check
diff(rf.check)
res$steps
head(res$dev.db)
}
