% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision_modus.R
\name{decision_modus}
\alias{decision_modus}
\title{A function to get a decision (modus) from a vector of classes}
\usage{
decision_modus(data, variables = c("a", "n", "y"), max_freq = TRUE)
}
\arguments{
\item{data}{is a table containing the classes.}

\item{variables}{is the class to look for.}

\item{max_freq}{is a logical parameter (default == TRUE) delivers either the 
most ocurring class or a summary.}
}
\description{
\code{decision_modus} is a function that can be used to find the most frequent
(modus) decision. The classes can be defined by the user (e.g., a", "n", "y" 
-> "ambiguos", "negaive", "positive"). This function is useful if large 
collections of varying decision (e.g., "a", "a", "a", "n", "n") need to be 
condensed to a single decision (3 x "a", 2 x "n" -> "a").
}
\examples{

# First example
# Enter a string of arbritary of "a","a","y","n"
# Result:
# [1] a
# Levels: a b n y

decision_modus(c("a","a","y","n","b"))

# Second example
# Analyze data from the decision_res_testdat.csv data file
library(data.table)
library(magrittr)
filename <- system.file("decision_res_testdat.csv", package = "PCRedux")
my_data <- as.data.frame(fread(filename))
head(my_data)

dec <- lapply(1L:nrow(my_data), function(i) {
       decision_modus(my_data[i, 2:4])
}) \%>\% unlist

names(dec) <- my_data[, 1]
dec

}
\author{
Stefan Roediger, Michal Burdukiewcz
}
\keyword{decision}
\keyword{modus}
