% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootEfronts.R
\name{bootEfronts}
\alias{bootEfronts}
\title{Bootstrapped Efficient Frontiers}
\usage{
bootEfronts(
  returns,
  pspec,
  rf = 0.003,
  npoints = 20,
  B = 3,
  Seed = NULL,
  gmv = TRUE,
  maxSR = FALSE,
  xlim = NULL,
  ylim = NULL,
  k.sigma = 2,
  k.mu = 2,
  digits = 4,
  figTitle = NULL
)
}
\arguments{
\item{returns}{A multivarite xts returns object}

\item{pspec}{PortfolioAnalytics portfolio specification object}

\item{rf}{Risk-free rate as a decimal, default 0.003}

\item{npoints}{Number of points on efficient frontier, default 10}

\item{B}{Number of bootstrap samples, default 3}

\item{Seed}{Seed of bootstrap random number generator, default NULL}

\item{gmv}{Logical variable, default TRUE}

\item{maxSR}{Logical variable, default FALSE}

\item{xlim}{Numeric x axis plot limits, default NULL}

\item{ylim}{Numeric y axis plot limits, default NULL}

\item{k.sigma}{Numeric value}

\item{k.mu}{Numeric value}

\item{digits}{Number of significant digits for numeric values}

\item{figTitle}{Optional figure title, default NULL}
}
\value{
No value returned, instead a bootstrapped efficient frontiers plot
with options described in the above details.
}
\description{
Computes and plots bootstrapped portfolio efficient frontiers, 
with optional bullet points for GMV portfolios and tangency portfolios.
}
\details{
k.sigma controls horizontal axis plotting range if xlim = NULL, and
k.mu controls vertical axis plotting range if ylim = NULL. Adjust k.mu and
k.sigma to eliminate plot "Line out of bounds" Warnings.
gmv = TRUE to display a bullet at global minimum variance portfolio
maxSR = TRUE to display a bullet at tangency portfolio
}
\examples{
args(bootEfronts)
}
