% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcps.R, R/plot.pcps.R, R/print.pcps.R,
%   R/print.summarypcps.R, R/scores.pcps.R, R/summary.pcps.R
\encoding{UTF-8}
\name{pcps}
\alias{pcps}
\alias{print.pcps}
\alias{summary.pcps}
\alias{print.summarypcps}
\alias{plot.pcps}
\alias{scores.pcps}
\title{Principal Coordinates of Phylogenetic Structure}
\usage{
pcps(
  comm,
  phylodist,
  checkdata = TRUE,
  method = "bray",
  squareroot = TRUE,
  correlations = TRUE
)

\method{plot}{pcps}(
  x,
  groups = NULL,
  choices = c(1, 2),
  display = "text",
  showlabel = TRUE,
  ...
)

\method{print}{pcps}(x, ...)

\method{print}{summarypcps}(x, ...)

scores.pcps(x, choices = c(1, 2), ...)

\method{summary}{pcps}(object, choices = c(1, 2), ...)
}
\arguments{
\item{comm}{Community data, with species as columns and sampling units as rows. 
This matrix can contain either presence/absence or abundance data.
Alternatively comm can be an object of class metacommunity.data, an alternative
way to set all data.frames/matrices. When you use the class metacommunity.data the argument
phylodist must not be specified. See details.}

\item{phylodist}{Matrix containing phylogenetic distances between species.}

\item{checkdata}{Logical argument (TRUE or FALSE) to check if species
sequence in the community data follows the same order as the one in the phylodist 
matrix (Default checkdata = TRUE).}

\item{method}{Dissimilarity index, as accepted by \code{\link{vegdist}} (Default dist="bray").}

\item{squareroot}{Logical argument (TRUE or FALSE) to specify if use square root of 
dissimilarity index (Default squareroot = TRUE).}

\item{correlations}{Logical argument (TRUE or FALSE) to specify if are calculed the correlations
between each PCPS and each species in matrix P (Default correlations = TRUE).}

\item{x}{An object of class pcps.}

\item{groups}{Factor giving the groups (Clades) for each species  (Default groups = NULL).}

\item{choices}{Axes for re-scaling. Choices must have length equal to two (Default choices = c(1, 2)).}

\item{display}{Display text or points for the sampling units, partial match to "text" or "points" (Default display = "text").}

\item{showlabel}{Label the groups by their names in the centroid of the object.}

\item{...}{Other parameters for the respective functions.}

\item{object}{An object of class pcps.}
}
\value{
\item{P}{Phylogeny-weighted species composition matrix.} \item{values}{The eigenvalues, 
relative eigenvalues and cumulative relative eigenvalues.} \item{vectors}{The principal coordinates
of phylogenetic structure (PCPS).} \item{correlations}{Correlations between a PCPS axis and 
phylogenetically weighted species abundances or frequencies.} \item{scores}{Scores for biplot graphics.}
}
\description{
Function to generate Principal Coordinates of Phylogenetic Structure (PCPS).
}
\details{
The function obtains a matrix containing phylogeny-weighted species composition 
(\code{\link{matrix.p}}) and is submitted to principal coordinates analysis (PCoA). 
This method generates the principal coordinates of phylogenetic structure 
(PCPS) (Duarte, 2011).

The sequence species show up in the community data matrix must be the 
same as they show up in the phylogenetic distance matrix. The 
function \code{\link{organize.pcps}} organizes the data, placing the matrices of 
community and phylogenetic distance in the same order. The use of  
organize.pcps is not requered for run this function, but is recommended. In this way 
the arguments comm and phylodist can be specified them as normal arguments or by passing
them with the object returned by the function \code{\link{organize.pcps}} using, in this
case only the argument comm. Using the object returned by organize.pcps, the comm argument 
is used as an alternative way of entering to set all data.frames/matrices, and therefore 
the phylodist argument must not be specified.

The function summary or the function scores.pcps re-scales the correlation values 
for obtain the scores for \code{\link{biplot}} graphics. The function plot draws a 
simple biplot and represent clades as "spider" graphs (see \code{\link{ordispider}}).
}
\note{
\strong{IMPORTANT}: The sequence species show up in the community data matrix MUST be the 
same as they show up in the phylogenetic distance matrix. See details and \code{\link{organize.pcps}}.
}
\examples{

data(ADRS)
res<-pcps(ADRS$community, ADRS$phylo)
res
summary(res)
summary(res, choices = c(1, 2))$scores
plot(res, display = "text", groups = c(rep("Clade-A", 2), rep("Clade-B", 4)))

}
\references{
Duarte, L.S. (2011). Phylogenetic habitat filtering influences forest nucleation 
in grasslands. Oikos, 120, 208:215.
}
\seealso{
\code{\link{matrix.p}}, \code{\link{wcmdscale}}, \code{\link{ordispider}}, \code{\link{ordilabel}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{PCPS}
