% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.MFAmix.R
\name{predict.MFAmix}
\alias{predict.MFAmix}
\title{Prediction of new scores in MFAmix}
\usage{
\method{predict}{MFAmix}(object, data, rename.level = FALSE, ...)
}
\arguments{
\item{object}{an object of class MFAmix obtained with the function 
\code{MFAmix}.}

\item{data}{a data frame containing the description of the new observations 
on all the variables. This data frame  will be split into \code{G} groups according 
to the vector \code{groups}.}

\item{rename.level}{boolean, if TRUE all the levels of the qualitative variables
are renamed as follows: "variable_name=level_name". This prevents to have 
identical names for the levels.}

\item{\ldots}{urther arguments passed to or from other methods. 
They are ignored in this function.}
}
\value{
Returns the matrix of the scores of the new observations on 
the principal components or on the rotated principal components of MFAmix.
}
\description{
This function performs the scores of new observations 
on the principal components of MFAmix. In other words, this function 
is projecting the new observations onto the principal components 
of MFAmix obtained previoulsy on a separated dataset. 
Note that the new observations must be described with the 
same variables than those used in MFAmix. The groups of variables
must also be identical.
}
\examples{
data(gironde)
class.var<-c(rep(1,9),rep(2,5),rep(3,9),rep(4,4))
names<-c("employment","housing","services","environment")
dat<-cbind(gironde$employment,gironde$housing,
           gironde$services,gironde$environment)
n <- nrow(dat)
set.seed(10)
sub <- sample(1:n,520)

res<-MFAmix(data=dat[sub,],groups=class.var,
            name.groups=names, rename.level=TRUE, 
            ndim=3,graph=FALSE)

#Predict scores of new data
pred<-predict(res,data=dat[-sub,])
plot(res,choice="ind",cex=0.6,lim.cos2.plot=0.7)  
points(pred[1:5,c(1,2)],col=2,pch=16,cex=0.6)
text(pred[1:5,c(1,2)], labels = rownames(dat[-sub,])[1:5],
     col=2,pos=3,cex=0.6)
}
\references{
Chavent M., Kuentz-Simonet V., Labenne A., Saracco J.,
Multivariate analysis of mixed data: The PCAmixdata R package, 
arXiv:1411.4911 [stat.CO].
}
\seealso{
\code{\link{MFAmix}}
}
\author{
Marie Chavent \email{marie.chavent@u-bordeaux.fr}, Amaury Labenne.
}
